## Contribute To Special Features

Community made patches, localizations, bug reports and contributions are always welcome!

When contributing please ensure you follow the guidelines below so that we can keep on top of things.

__Please Note:__ GitHub is for bug reports and contributions only - if you have a support question or a request for a customization don't post here, go to our [forum thread](https://forum.kodi.tv/showthread.php?tid=327042) instead.

## Getting Started

* Submit a ticket for your issue, assuming one does not already exist.
  * Raise it on our [Issue Tracker](https://github.com/kasamedia/plugin.video.specialfeatures/issues)
  * Clearly describe the issue including steps to reproduce the bug.
  * Make sure you fill in the earliest version that you know has the issue as well as the version of Kodi you're using.

## Making Changes

* Fork the repository on GitHub
* Make the changes to your forked repository
* When committing, reference your issue (if present) and include a note about the fix
* If possible, and if applicable, please also add/update unit tests for your changes
* Push the changes to your fork and submit a pull request to the 'master' branch of the repository

## Code Documentation

* We ensure that every Special Features function is documented well
* Please use spaces and not tabs. The indent size should be 4 for all Python code.

At this point you're waiting on us to merge your pull request. We'll review all pull requests, and make suggestions and changes if necessary.

# Additional Resources
* [General GitHub Documentation](https://help.github.com/)
* [GitHub Pull Request documentation](https://help.github.com/send-pull-requests/)
