## 1.13.4 (November 13, 2020)

FEATURES:

* **New Resource** `linode_vlan`

## 1.13.3 (October 27, 2020)

ENHANCEMENTS:

* resource/linode_object_storage_key: Add `bucket_access` field for Limited Access Object Storage Keys.

## 1.13.2 (October 7, 2020)

ENHANCEMENTS:

* resource/linode_object_storage_bucket: Add `cert` field.

## 1.13.0 (September 18, 2020)

FEATURES:

* **New Resource** `linode_object_storage_object`

BUG FIXES:

* Fixed an issue with the `linode_domain` and `linode_domain_record` resources where the rounding of domain second values for `ttl_sec`, `retry_sec`, `expire_sec` and `refresh_sec` fields caused inconsistent state warnings. A diff-suppressor was added to silence state discrepancies between declared and provisioned state. This now works as it was originally documented.

## 1.12.3 (June 08, 2020)

Note: This release was published incorrectly as 1.12.3, but was intended as 1.11.3.

BUG FIXES:

* Fixed an issue where updating a disk can timeout even after `finished` was emitted.

## 1.11.2 (June 05, 2020)

BUG FIXES:

* Fixed an issue where sometimes, creating an instance disk would appear to timeout even after `finished` was emitted.

## 1.11.1 (May 28, 2020)

BUG FIXES:

* Fixed an issue where a missing `Update` timestamp for a Volume could cause a panic.

## 1.11.0 (May 26, 2020)

FEATURES:

* **New Resource** `linode_firewall`

## 1.10.0 (May 05, 2020)

FEATURES:

* **New Resource** `linode_lke_cluster`

## 1.9.3 (April 17, 2020)

ENHANCEMENTS:

* Provide more version/client information in the User-Agent header. By default now, the header will include the Terraform CLI, terraform-provider-linode, and linodego versions.

BUG FIXES:

* `swap_size` attribute changes would not change the underlying swap disk's size as the boot disk size was fixed from creation. This will now actually change the swap disk size and scale the boot disk as needed.

* Resizing a linode while resizing disk failed in certain cases, mostly due to the order of resizing operations. For instance, expanding a disk while upgrading a linode to a type with more disk capacity failed when the current linode type did not support the staged disk changes. The inverse also happened with downgrading a linode to a type with less capacity and shrinking the disks to fit the new spec; it would fail because the linode resize would occur before the disk changes were applied. Both cases are now fixed.

## 1.9.2 (February 24, 2020)

FEATURES:

* **New Data Source** `linode_stackscript`
* **New Data Source** `linode_domain_record`

ENHANCEMENTS:

* Updates linodego to v0.13.0 which enables retrying on 429 errors.

BUG FIXES:

* SRV Domain record names are generated by the API, setting them would cause an infinite loop of trying to update the field. The `name` attribute can now safely be omitted from SRV records.
* SRV Domain record targets must be the associated domain or a related FQDN. The API will automatically format subdomains as such, which would also cause a non-deterministic state. This is now validated before creating/updating records.

## 1.9.1 (December 03, 2019)

ENHANCEMENTS:

* Updates linodego to v0.12.2 which retries `Linode Busy.` errors.

## 1.9.0 (November 25, 2019)

FEATURES:

* **New Data Source** `linode_object_storage_cluster`
* **New Resource** `linode_object_storage_key`
* **New Resource** `linode_object_storage_bucket`

ENHANCEMENTS:

* Migration to standalone sdk
* Uses linodego v0.12.1

BUG FIXES:

* providing stackscript data on a disk would cause a `panic: assignment to entry in nil map` ([#62](https://github.com/terraform-providers/terraform-provider-linode/pull/62))

## 1.8.0 (July 16, 2019)

BACKWARDS INCOMPATIBILITIES / NOTES:

* resource/linode\_instance: `config.root_device` no longer supplies `/dev/root` when no `/dev/sda` device is present (this was an API work-around that is no longer needed) ([#10](https://github.com/terraform-providers/terraform-provider-linode/issues/10), [#18](https://github.com/terraform-providers/terraform-provider-linode/issues/18))

## 1.7.0 (July 08, 2019)

ENHANCEMENTS:

* Compatible with Terraform v0.12.0+
* Uses linodego v0.10.0
* Examples updated with new TF config syntax

BUG FIXES:

* The Linode API resizes disks by default when an instance is resized. This behavior is now accounted for -- Terraform will not resize disks unless a new size is specified in the config.
* The provider now waits for instance resizing to complete before attempting to issue disk resize jobs against an instance. This was required because new jobs issued to actively-resizing instances fail.
* Disk resizing and instance resizing are now executed in the correct order.

## 1.6.0 (April 10, 2019)

FEATURES:

* **New Resource** `linode_rdns`

* **New Data Resource** `linode_networking_ip`

ENHANCEMENTS:

* Builds now use `go mod`
* provider: Support custom `ua_prefix`
* provider: Support custom API endpoint `url`

BUG FIXES:

* Documentation and examples for `linode_domain` resource were missing required `type` field
* `linode_domain_record` field `ttl_sec` accepts `0`, as the API does (#35)
* `linode_domain` fields `ttl_sec`, `retry_sec`, `expire_sec`, and `refresh_sec` now accept `0`, as the API does

## 1.5.0 (February 06, 2019)

FEATURES:

* **New Data Resource** `linode_domain`

ENHANCEMENTS:

* Documentation has been revised with links to relevant Linode Guides & Tutorials

BUG FIXES:

* `linode_instance.alerts.0.network_out` and `linode_instance.alerts.0.transfer_quota` were not created or updating correctly ([#27](https://github.com/terraform-providers/terraform-provider-linode/issues/27))

## 1.4.0 (January 14, 2019)

BACKWARDS INCOMPATIBILITIES / NOTES:

* resource/linode\_instance: `tags` field is now a `TypeSet` instead of a `TypeList` ([#16](https://github.com/terraform-providers/terraform-provider-linode/issues/16))

ENHANCEMENTS:

* resource/linode\_domain: Add `tags` field
* resource/linode\_nodebalancer: Add `tags` field
* resource/linode\_volume: Add `tags` field

BUG FIXES:

* `linode_nodebalancer_node.label` was updated from optional to required, the Linode API has always required this field

## 1.3.0 (November 27, 2018)

ENHANCEMENTS:

* resource/linode\_instance: Add `timeouts` support for `create`, `update`, and `delete` (defaults 10, 20, 10)
* resource/linode\_image: Add `timeouts` support for `create` (defaults 20)
* resource/linode\_volume: Add `timeouts` support for `create`, `update`, and `delete` (defaults 10, 20, 10)

## 1.2.0 (November 08, 2018)

ENHANCEMENTS:

* resource/linode\_instance: Add `tags` field
* resource/linode\_instance: Add `authorized_users` field and added `authorized_users` field to `disk`

## 1.1.0 (October 31, 2018)

FEATURES:

* **New Resource** `linode_token`

* **New Data Resource** `linode_user`
* **New Data Resource** `linode_account`
* **New Data Resource** `linode_profile`

BUG FIXES:

* `linode_nodebalancer_config.check_passive` changes were not handled ([#4](https://github.com/terraform-providers/terraform-provider-template/issues/4))

## 1.0.0 (October 18, 2018)

FEATURES:

* **New Resource** `linode_instance` Initial work from @btobolaski!
* **New Resource** `linode_domain`
* **New Resource** `linode_domain_record`
* **New Resource** `linode_image` Thanks @akerl!
* **New Resource** `linode_nodebalancer`
* **New Resource** `linode_nodebalancer_config`
* **New Resource** `linode_nodebalancer_node`
* **New Resource** `linode_stackscript`
* **New Resource** `linode_sshkey`
* **New Resource** `linode_volume`

* **New Data Resource** `linode_image` Thanks @cliedeman!
* **New Data Resource** `linode_instance_type` Thanks @cliedeman!
* **New Data Resource** `linode_region` Thanks @cliedeman!
* **New Data Resource** `linode_sshkey`
