/*
 * Copyright (C) 2009 Dirk Schulze <krit@webkit.org>
 * Copyright (C) 2021-2022 Apple Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#pragma once

#include <WebCore/FilterEffect.h>

namespace WebCore {

class SourceAlpha final : public FilterEffect {
    WTF_DEPRECATED_MAKE_FAST_ALLOCATED(SourceAlpha);
    WTF_OVERRIDE_DELETE_FOR_CHECKED_PTR(SourceAlpha);
public:
    WEBCORE_EXPORT static Ref<SourceAlpha> create(const DestinationColorSpace& = DestinationColorSpace::SRGB());

    static AtomString effectName() { return FilterEffect::sourceAlphaName(); }

private:
    explicit SourceAlpha(DestinationColorSpace);

    OptionSet<FilterRenderingMode> supportedFilterRenderingModes(OptionSet<FilterRenderingMode> preferredFilterRenderingModes) const override;
    std::unique_ptr<FilterEffectApplier> createSoftwareApplier() const override;
    std::unique_ptr<FilterEffectApplier> createAcceleratedApplier() const override;

    WTF::TextStream& externalRepresentation(WTF::TextStream&, FilterRepresentation) const override;
};

} //namespace WebCore

SPECIALIZE_TYPE_TRAITS_FILTER_FUNCTION(SourceAlpha)
