// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/known/emptypb"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyUnixAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesUnixAddr() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewUnixAddr()
				CopyUnixAddr(dest, src)
				assert.Equal(t, src, dest)
				CopyUnixAddr(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyUnixAddrSlice(t *testing.T) {
	src := []UnixAddr{}
	dest := []UnixAddr{}
	// Test CopyTo empty
	dest = CopyUnixAddrSlice(dest, src)
	assert.Equal(t, []UnixAddr{}, dest)

	// Test CopyTo larger slice
	src = GenTestUnixAddrSlice()
	dest = CopyUnixAddrSlice(dest, src)
	assert.Equal(t, GenTestUnixAddrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyUnixAddrSlice(dest, src)
	assert.Equal(t, GenTestUnixAddrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyUnixAddrSlice(dest, []UnixAddr{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyUnixAddrSlice(dest, src)
	assert.Equal(t, GenTestUnixAddrSlice(), dest)
}

func TestCopyUnixAddrPtrSlice(t *testing.T) {
	src := []*UnixAddr{}
	dest := []*UnixAddr{}
	// Test CopyTo empty
	dest = CopyUnixAddrPtrSlice(dest, src)
	assert.Equal(t, []*UnixAddr{}, dest)

	// Test CopyTo larger slice
	src = GenTestUnixAddrPtrSlice()
	dest = CopyUnixAddrPtrSlice(dest, src)
	assert.Equal(t, GenTestUnixAddrPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyUnixAddrPtrSlice(dest, src)
	assert.Equal(t, GenTestUnixAddrPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyUnixAddrPtrSlice(dest, []*UnixAddr{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyUnixAddrPtrSlice(dest, src)
	assert.Equal(t, GenTestUnixAddrPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONUnixAddrUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewUnixAddr()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewUnixAddr(), dest)
}

func TestMarshalAndUnmarshalJSONUnixAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesUnixAddr() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewUnixAddr()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteUnixAddr(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoUnixAddrFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesUnixAddr() {
		t.Run(name, func(t *testing.T) {
			dest := NewUnixAddr()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoUnixAddrUnknown(t *testing.T) {
	dest := NewUnixAddr()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewUnixAddr(), dest)
}

func TestMarshalAndUnmarshalProtoUnixAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesUnixAddr() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewUnixAddr()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteUnixAddr(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufUnixAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesUnixAddr() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &emptypb.Empty{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewUnixAddr()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesUnixAddr() map[string][]byte {
	return map[string][]byte{
		"invalid_field":        {0x02},
		"Name/wrong_wire_type": {0xc},
		"Name/missing_value":   {0xa},
		"Net/wrong_wire_type":  {0x14},
		"Net/missing_value":    {0x12},
	}
}

func genTestEncodingValuesUnixAddr() map[string]*UnixAddr {
	return map[string]*UnixAddr{
		"empty":     NewUnixAddr(),
		"Name/test": {Name: "test_name"},
		"Net/test":  {Net: "test_net"},
	}
}
