// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectortrace "go.opentelemetry.io/proto/slim/otlp/collector/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExportTraceServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExportTraceServiceResponse()
				CopyExportTraceServiceResponse(dest, src)
				assert.Equal(t, src, dest)
				CopyExportTraceServiceResponse(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExportTraceServiceResponseSlice(t *testing.T) {
	src := []ExportTraceServiceResponse{}
	dest := []ExportTraceServiceResponse{}
	// Test CopyTo empty
	dest = CopyExportTraceServiceResponseSlice(dest, src)
	assert.Equal(t, []ExportTraceServiceResponse{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportTraceServiceResponseSlice()
	dest = CopyExportTraceServiceResponseSlice(dest, src)
	assert.Equal(t, GenTestExportTraceServiceResponseSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportTraceServiceResponseSlice(dest, src)
	assert.Equal(t, GenTestExportTraceServiceResponseSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportTraceServiceResponseSlice(dest, []ExportTraceServiceResponse{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportTraceServiceResponseSlice(dest, src)
	assert.Equal(t, GenTestExportTraceServiceResponseSlice(), dest)
}

func TestCopyExportTraceServiceResponsePtrSlice(t *testing.T) {
	src := []*ExportTraceServiceResponse{}
	dest := []*ExportTraceServiceResponse{}
	// Test CopyTo empty
	dest = CopyExportTraceServiceResponsePtrSlice(dest, src)
	assert.Equal(t, []*ExportTraceServiceResponse{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportTraceServiceResponsePtrSlice()
	dest = CopyExportTraceServiceResponsePtrSlice(dest, src)
	assert.Equal(t, GenTestExportTraceServiceResponsePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportTraceServiceResponsePtrSlice(dest, src)
	assert.Equal(t, GenTestExportTraceServiceResponsePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportTraceServiceResponsePtrSlice(dest, []*ExportTraceServiceResponse{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportTraceServiceResponsePtrSlice(dest, src)
	assert.Equal(t, GenTestExportTraceServiceResponsePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExportTraceServiceResponseUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExportTraceServiceResponse()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExportTraceServiceResponse(), dest)
}

func TestMarshalAndUnmarshalJSONExportTraceServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExportTraceServiceResponse()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExportTraceServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExportTraceServiceResponseFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportTraceServiceResponse() {
		t.Run(name, func(t *testing.T) {
			dest := NewExportTraceServiceResponse()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExportTraceServiceResponseUnknown(t *testing.T) {
	dest := NewExportTraceServiceResponse()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExportTraceServiceResponse(), dest)
}

func TestMarshalAndUnmarshalProtoExportTraceServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExportTraceServiceResponse()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExportTraceServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportTraceServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceResponse() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectortrace.ExportTraceServiceResponse{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExportTraceServiceResponse()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportTraceServiceResponse() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"PartialSuccess/wrong_wire_type": {0xc},
		"PartialSuccess/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportTraceServiceResponse() map[string]*ExportTraceServiceResponse {
	return map[string]*ExportTraceServiceResponse{
		"empty":               NewExportTraceServiceResponse(),
		"PartialSuccess/test": {PartialSuccess: *GenTestExportTracePartialSuccess()},
	}
}
