// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestSample_MoveTo(t *testing.T) {
	ms := generateTestSample()
	dest := NewSample()
	ms.MoveTo(dest)
	assert.Equal(t, NewSample(), ms)
	assert.Equal(t, generateTestSample(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestSample(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newSample(internal.NewOrigSample(), sharedState)) })
	assert.Panics(t, func() { newSample(internal.NewOrigSample(), sharedState).MoveTo(dest) })
}

func TestSample_CopyTo(t *testing.T) {
	ms := NewSample()
	orig := NewSample()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestSample()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newSample(internal.NewOrigSample(), sharedState)) })
}

func TestSample_StackIndex(t *testing.T) {
	ms := NewSample()
	assert.Equal(t, int32(0), ms.StackIndex())
	ms.SetStackIndex(int32(13))
	assert.Equal(t, int32(13), ms.StackIndex())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newSample(&otlpprofiles.Sample{}, sharedState).SetStackIndex(int32(13)) })
}

func TestSample_Values(t *testing.T) {
	ms := NewSample()
	assert.Equal(t, pcommon.NewInt64Slice(), ms.Values())
	ms.orig.Values = internal.GenerateOrigTestInt64Slice()
	assert.Equal(t, pcommon.Int64Slice(internal.GenerateTestInt64Slice()), ms.Values())
}

func TestSample_AttributeIndices(t *testing.T) {
	ms := NewSample()
	assert.Equal(t, pcommon.NewInt32Slice(), ms.AttributeIndices())
	ms.orig.AttributeIndices = internal.GenerateOrigTestInt32Slice()
	assert.Equal(t, pcommon.Int32Slice(internal.GenerateTestInt32Slice()), ms.AttributeIndices())
}

func TestSample_LinkIndex(t *testing.T) {
	ms := NewSample()
	assert.Equal(t, int32(0), ms.LinkIndex())
	ms.SetLinkIndex(int32(13))
	assert.Equal(t, int32(13), ms.LinkIndex())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newSample(&otlpprofiles.Sample{}, sharedState).SetLinkIndex(int32(13)) })
}

func TestSample_TimestampsUnixNano(t *testing.T) {
	ms := NewSample()
	assert.Equal(t, pcommon.NewUInt64Slice(), ms.TimestampsUnixNano())
	ms.orig.TimestampsUnixNano = internal.GenerateOrigTestUint64Slice()
	assert.Equal(t, pcommon.UInt64Slice(internal.GenerateTestUInt64Slice()), ms.TimestampsUnixNano())
}

func generateTestSample() Sample {
	ms := newSample(internal.GenTestOrigSample(), internal.NewState())
	return ms
}
