// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectorlogs "go.opentelemetry.io/proto/slim/otlp/collector/logs/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcollectorlogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportLogsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigExportLogsPartialSuccess()
				CopyOrigExportLogsPartialSuccess(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigExportLogsPartialSuccess(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigExportLogsPartialSuccessUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigExportLogsPartialSuccess()
	UnmarshalJSONOrigExportLogsPartialSuccess(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigExportLogsPartialSuccess(), dest)
}

func TestMarshalAndUnmarshalJSONOrigExportLogsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigExportLogsPartialSuccess(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigExportLogsPartialSuccess()
				UnmarshalJSONOrigExportLogsPartialSuccess(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigExportLogsPartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigExportLogsPartialSuccessFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportLogsPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigExportLogsPartialSuccess()
			require.Error(t, UnmarshalProtoOrigExportLogsPartialSuccess(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportLogsPartialSuccessUnknown(t *testing.T) {
	dest := NewOrigExportLogsPartialSuccess()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigExportLogsPartialSuccess(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigExportLogsPartialSuccess(), dest)
}

func TestMarshalAndUnmarshalProtoOrigExportLogsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigExportLogsPartialSuccess(src))
				gotSize := MarshalProtoOrigExportLogsPartialSuccess(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigExportLogsPartialSuccess()
				require.NoError(t, UnmarshalProtoOrigExportLogsPartialSuccess(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigExportLogsPartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportLogsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportLogsPartialSuccess(src))
			gotSize := MarshalProtoOrigExportLogsPartialSuccess(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectorlogs.ExportLogsPartialSuccess{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigExportLogsPartialSuccess()
			require.NoError(t, UnmarshalProtoOrigExportLogsPartialSuccess(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportLogsPartialSuccess() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                      {0x02},
		"RejectedLogRecords/wrong_wire_type": {0xc},
		"RejectedLogRecords/missing_value":   {0x8},
		"ErrorMessage/wrong_wire_type":       {0x14},
		"ErrorMessage/missing_value":         {0x12},
	}
}

func genTestEncodingValuesExportLogsPartialSuccess() map[string]*otlpcollectorlogs.ExportLogsPartialSuccess {
	return map[string]*otlpcollectorlogs.ExportLogsPartialSuccess{
		"empty":                   NewOrigExportLogsPartialSuccess(),
		"RejectedLogRecords/test": {RejectedLogRecords: int64(13)},
		"ErrorMessage/test":       {ErrorMessage: "test_errormessage"},
	}
}
