# v2.11 to 2.12

## Cluster secret scoping changes

From Argo CD 2.12, there have been some changes to the use of cluster secrets where a `project` is a non-empty value. 
Previously, an `Application` or `ApplicationSet` would use any cluster secret matching the URL of the `repoUrl` field. 
From 2.12, we now check to see whether the project field of an application _also_ matches the project field of the cluster 
secret. What this means is that if you have a cluster secret scoped to `project-a`, an application scoped to `project-b`
can no longer make use of the secret. If you have a cluster secret that's intended to be used by applications in multiple 
projects, you need to **unset** the `project` field.

This also applies when using the Git generator in applicationsets; since an applicationset is not scoped to a particular
project any cluster secrets it makes use of also needs to be globally scoped (i.e. any secret needs to have an unset 
`project`).

## Upgraded Helm Version

Note that bundled Helm version has been upgraded from 3.14.4 to 3.15.2.

## Image Registry Change for `redis` and `haproxy`

Argo CD 2.12 upgraded its [upstream redis-ha Helm chart](https://artifacthub.io/packages/helm/dandydev-charts/redis-ha/)
version from 4.22.3 to 4.26.6.

As part of the upgrade, the image registry for `redis` and `haproxy` was changed from DockerHub to ECR.

Make sure that the registry change will work for your environment. One example of a problem would be that your 
environment can use Cosign to verify the image signature for DockerHub but not for ECR. You would need to make sure your 
Image Validation policy includes the AWS ECR as an approved registry. Please validate that the registry change is
acceptable before upgrading.

## Server-Side Apply Management of ApplicationSet Fields

### Summary

If you are using server-side apply with multiple field managers to manage a single `selector` or `labelSelector` field 
in an ApplicationSet, that field management must be changed to be atomic starting with 2.12. 

### Details

Argo CD 2.12 upgraded its controller-gen version from 0.4.1 to 0.14.0. As part of that change, several ApplicationSet
CRD fields now have `x-kubernetes-map-type: atomic`.

Each of the affected fields is a label selector with two child keys: `matchLabels` and `matchExpressions`.

Prior to this change, two field managers could manage the `matchLabels` and `matchExpressions` fields independently.
Starting with the 2.12 CRD, a single field manager must manage both of those fields. This behavior is in line with the
upstream behavior of the label selector struct.

See the [Kubernetes server-side apply merge strategy docs](https://kubernetes.io/docs/reference/using-api/server-side-apply/#merge-strategy)
for more information about the fields' behavior.

The affected ApplicationSet fields are the following (jq selector syntax):

* `.spec.generators[].selector`
* `.spec.generators[].cluster.selector`
* `.spec.generators[].clusterDecisionResource.labelSelector`
* `.spec.generators[].matrix.generators[].selector`
* `.spec.generators[].merge.generators[].selector`


## Sanitized project API response

Due to security reasons ([GHSA-786q-9hcg-v9ff](https://github.com/argoproj/argo-cd/security/advisories/GHSA-786q-9hcg-v9ff)),
the project API response was sanitized to remove sensitive information. This includes
credentials of project-scoped repositories and clusters.

> **Note:** The 2.12 series has been EOL for some time and has not received security updates. 2.12.13 was patched for critical 
> CVE-2025-55190 but was not patched for other vulnerabilities. It is important to upgrade to a supported version as quickly as possible.
