var oil_temp_eng0    = props.globals.getNode("/engines/engine[0]/oil-temperature-degf", 1);
var fuel_press_eng0  = props.globals.getNode("/engines/engine[0]/fuel-pressure-psi", 1);
var egt_eng0         = props.globals.getNode("/engines/engine[0]/egt-degf-fix", 1);

var oil_temp_eng1    = props.globals.getNode("/engines/engine[1]/oil-temperature-degf", 1);
var fuel_press_eng1  = props.globals.getNode("/engines/engine[1]/fuel-pressure-psi", 1);
var egt_eng1         = props.globals.getNode("/engines/engine[1]/egt-degf-fix", 1);

var oatf             = props.globals.getNode("/environment/temperature-degf", 1);

var oil_temp_inst0   = props.globals.getNode("/instrumentation/engine[0]/oil-temp", 1);
var fuel_press_inst0 = props.globals.getNode("/instrumentation/engine[0]/fuel-press", 1);
var cht_inst0        = props.globals.getNode("/instrumentation/engine[0]/cht-degf", 1);

var oil_temp_inst1   = props.globals.getNode("/instrumentation/engine[1]/oil-temp", 1);
var fuel_press_inst1 = props.globals.getNode("/instrumentation/engine[1]/fuel-press", 1);
var cht_inst1        = props.globals.getNode("/instrumentation/engine[1]/cht-degf", 1);

var initialise_temp = func {
  # all pressures initialized to 0.0
  fuel_press_inst0.setDoubleValue(0.0);
  oil_temp_eng0.setDoubleValue(0.0);

  fuel_press_inst1.setDoubleValue(0.0);
  oil_temp_eng1.setDoubleValue(0.0);

  # all temperatures initialized to environment temperature
  oil_temp_inst0.setDoubleValue(oatf.getValue());
  cht_inst0.setDoubleValue(oatf.getValue());

  oil_temp_inst1.setDoubleValue(oatf.getValue());
  cht_inst1.setDoubleValue(oatf.getValue());

  # settimer(update_press, 0);
  update_temp ();
  print ("fluids system initialized");
}

var update_temp = func {
  if (getprop("/engines/engine[0]/running") != 0) {
    interpolate("/instrumentation/engine[0]/cht-degf0", oil_temp_eng0.getValue()+50, 10);
    interpolate("/instrumentation/engine[0]/oil-temp0", oil_temp_eng0.getValue(), 30);
  } else {
    interpolate("/instrumentation/engine[0]/cht-degf0", oatf.getValue(), 100);
    interpolate("/instrumentation/engine[0]/oil-temp0", oatf.getValue(), 600)
  }
  if (getprop("/engines/engine[1]/running") != 0) {
    interpolate("/instrumentation/engine[1]/cht-degf1", oil_temp_eng1.getValue()+50, 10);
    interpolate("/instrumentation/engine[1]/oil-temp1", oil_temp_eng1.getValue(), 30);
  } else {
    interpolate("/instrumentation/engine[1]/cht-degf1", oatf.getValue(), 100);
    interpolate("/instrumentation/engine[1]/oil-temp1", oatf.getValue(), 600);
  }
  settimer(update_temp,0.1);
}

setlistener("/sim/signals/fdm-initialized", initialise_temp);
