/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.xml;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class XML {
    private static final Logger logger = LoggerFactory.getLogger(XML.class);

    private XML() {
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        DocumentBuilderFactory instance = DocumentBuilderFactory.newInstance();
        instance.setXIncludeAware(false);
        instance.setExpandEntityReferences(false);
        try {
            instance.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            try {
                instance.setFeature("http://xerces.apache.org/xerces2-j/features.html#disallow-doctype-decl", true);
            }
            catch (ParserConfigurationException e2) {
                logger.info("Unable to set feature to disallow DTD (doctypes): XML External Entity (XXE) attack risk", (Throwable)e);
            }
        }
        try {
            instance.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            logger.info("Unable to set feature to disable load-external-dtd: XML External Entity (XXE) attack risk", (Throwable)e);
        }
        try {
            instance.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException e) {
            try {
                instance.setFeature("http://xerces.apache.org/xerces2-j/features.html#external-general-entities", false);
            }
            catch (ParserConfigurationException e2) {
                logger.info("Unable to set feature to disallow external-general-entities: XML External Entity (XXE) attack risk", (Throwable)e);
            }
        }
        try {
            instance.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException e) {
            try {
                instance.setFeature("http://xerces.apache.org/xerces2-j/features.html#external-parameter-entities", false);
            }
            catch (ParserConfigurationException e2) {
                logger.info("Unable to set feature to disallow external-parameter-entities: XML External Entity (XXE) attack risk", (Throwable)e);
            }
        }
        return instance;
    }

    public static SAXParserFactory newSAXParserFactory() {
        SAXParserFactory instance = SAXParserFactory.newInstance();
        instance.setXIncludeAware(false);
        try {
            instance.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            try {
                instance.setFeature("http://xerces.apache.org/xerces2-j/features.html#disallow-doctype-decl", true);
            }
            catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e2) {
                logger.info("Unable to set feature to disallow DTD (doctypes): XML External Entity (XXE) attack risk", (Throwable)e);
            }
        }
        try {
            instance.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            try {
                instance.setFeature("http://xerces.apache.org/xerces2-j/features.html#external-general-entities", false);
            }
            catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e2) {
                logger.info("Unable to set feature to disallow external-general-entities: XML External Entity (XXE) attack risk", (Throwable)e);
            }
        }
        try {
            instance.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            try {
                instance.setFeature("http://xerces.apache.org/xerces2-j/features.html#external-parameter-entities", false);
            }
            catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e2) {
                logger.info("Unable to set feature to disallow external-parameter-entities: XML External Entity (XXE) attack risk", (Throwable)e);
            }
        }
        return instance;
    }

    public static XMLInputFactory newXMLInputFactory() {
        XMLInputFactory instance = XMLInputFactory.newInstance();
        try {
            instance.setProperty("javax.xml.stream.supportDTD", false);
        }
        catch (IllegalArgumentException e) {
            logger.info("Unable to set property {} to false: XML External Entity (XXE) attack risk", (Object)"javax.xml.stream.supportDTD", (Object)e);
        }
        try {
            instance.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        catch (IllegalArgumentException e) {
            logger.info("Unable to set property {} to false: XML External Entity (XXE) attack risk", (Object)"javax.xml.stream.isSupportingExternalEntities", (Object)e);
        }
        return instance;
    }

    public static TransformerFactory newTransformerFactory() {
        TransformerFactory instance = TransformerFactory.newInstance();
        try {
            instance.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (IllegalArgumentException e) {
            logger.info("Unable to set attribute {} to \"\": XML External Entity (XXE) attack risk", (Object)"http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)e);
        }
        try {
            instance.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException e) {
            logger.info("Unable to set attribute {} to \"\": XML External Entity (XXE) attack risk", (Object)"http://javax.xml.XMLConstants/property/accessExternalStylesheet", (Object)e);
        }
        return instance;
    }
}

