/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.io.IOException;
import java.net.URL;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.Patch;
import org.apache.unomi.api.PersonaWithSessions;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.actions.ActionType;
import org.apache.unomi.api.campaigns.Campaign;
import org.apache.unomi.api.conditions.ConditionType;
import org.apache.unomi.api.goals.Goal;
import org.apache.unomi.api.rules.Rule;
import org.apache.unomi.api.segments.Scoring;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.apache.unomi.shell.commands.DeploymentCommandSupport;

@Command(scope="unomi", name="deploy-definition", description="This will deploy Unomi definitions contained in bundles")
@Service
public class DeployDefinition
extends DeploymentCommandSupport {
    @Override
    public void processDefinition(String definitionType, URL definitionURL) {
        try {
            if ("* (All)".equals(definitionType)) {
                String definitionURLString = definitionURL.toString();
                for (String possibleDefinitionType : definitionTypes) {
                    if (!definitionURLString.contains(this.getDefinitionTypePath(possibleDefinitionType))) continue;
                    definitionType = possibleDefinitionType;
                    break;
                }
                if ("* (All)".equals(definitionType)) {
                    System.out.println("Couldn't resolve definition type for definition URL " + definitionURL);
                    return;
                }
            }
            boolean successful = true;
            switch (definitionType) {
                case "conditions": {
                    ConditionType conditionType = (ConditionType)CustomObjectMapper.getObjectMapper().readValue(definitionURL, ConditionType.class);
                    this.definitionsService.setConditionType(conditionType);
                    break;
                }
                case "actions": {
                    ActionType actionType = (ActionType)CustomObjectMapper.getObjectMapper().readValue(definitionURL, ActionType.class);
                    this.definitionsService.setActionType(actionType);
                    break;
                }
                case "goals": {
                    Goal goal = (Goal)CustomObjectMapper.getObjectMapper().readValue(definitionURL, Goal.class);
                    this.goalsService.setGoal(goal);
                    break;
                }
                case "campaigns": {
                    Campaign campaign = (Campaign)CustomObjectMapper.getObjectMapper().readValue(definitionURL, Campaign.class);
                    this.goalsService.setCampaign(campaign);
                    break;
                }
                case "personas": {
                    PersonaWithSessions persona = (PersonaWithSessions)CustomObjectMapper.getObjectMapper().readValue(definitionURL, PersonaWithSessions.class);
                    this.profileService.savePersonaWithSessions(persona);
                    break;
                }
                case "properties": {
                    PropertyType propertyType = (PropertyType)CustomObjectMapper.getObjectMapper().readValue(definitionURL, PropertyType.class);
                    this.profileService.setPropertyTypeTarget(definitionURL, propertyType);
                    this.profileService.setPropertyType(propertyType);
                    break;
                }
                case "rules": {
                    Rule rule = (Rule)CustomObjectMapper.getObjectMapper().readValue(definitionURL, Rule.class);
                    this.rulesService.setRule(rule);
                    break;
                }
                case "segments": {
                    Segment segment = (Segment)CustomObjectMapper.getObjectMapper().readValue(definitionURL, Segment.class);
                    this.segmentService.setSegmentDefinition(segment);
                    break;
                }
                case "scoring": {
                    Scoring scoring = (Scoring)CustomObjectMapper.getObjectMapper().readValue(definitionURL, Scoring.class);
                    this.segmentService.setScoringDefinition(scoring);
                    break;
                }
                case "patches": {
                    Patch patch = (Patch)CustomObjectMapper.getObjectMapper().readValue(definitionURL, Patch.class);
                    this.patchService.patch(patch);
                    break;
                }
                default: {
                    System.out.println("Unrecognized definition type:" + definitionType);
                    successful = false;
                }
            }
            if (successful) {
                System.out.println("Predefined definition registered : " + definitionURL.getFile());
            }
        }
        catch (IOException e) {
            System.out.println("Error while saving definition " + definitionURL);
            System.out.println(e.getMessage());
        }
    }
}

