/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.util.List;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.slice.DistributedConfiguration;
import org.apache.openjpa.slice.DistributionPolicy;
import org.apache.openjpa.slice.ReplicationPolicy;
import org.apache.openjpa.slice.SliceInfo;
import org.apache.openjpa.util.UserException;

public class SliceImplHelper {
    private static final Localizer _loc = Localizer.forPackage(SliceImplHelper.class);

    public static SliceInfo getSlicesByPolicy(Object pc, DistributedConfiguration conf, Object ctx) {
        List<String> actives = conf.getActiveSliceNames();
        Object policy = null;
        String[] targets = null;
        boolean replicated = SliceImplHelper.isReplicated(pc, conf);
        if (replicated) {
            policy = conf.getReplicationPolicyInstance();
            targets = ((ReplicationPolicy)policy).replicate(pc, actives, ctx);
            SliceImplHelper.assertSlices(targets, pc, conf.getActiveSliceNames(), policy);
        } else {
            policy = conf.getDistributionPolicyInstance();
            String target = ((DistributionPolicy)policy).distribute(pc, actives, ctx);
            if (target != null) {
                targets = new String[]{target};
                SliceImplHelper.assertSlices(targets, pc, conf.getActiveSliceNames(), policy);
            }
        }
        return targets != null ? new SliceInfo(replicated, targets) : null;
    }

    private static void assertSlices(String[] targets, Object pc, List<String> actives, Object policy) {
        if (targets == null || targets.length == 0) {
            throw new UserException(_loc.get("no-policy-slice", new Object[]{policy.getClass().getName(), pc, actives}));
        }
        for (String target : targets) {
            if (actives.contains(target)) continue;
            throw new UserException(_loc.get("bad-policy-slice", new Object[]{policy.getClass().getName(), target, pc, actives}));
        }
    }

    public static SliceInfo getSlicesByPolicy(OpenJPAStateManager sm, DistributedConfiguration conf, Object ctx) {
        return SliceImplHelper.getSlicesByPolicy(sm.getPersistenceCapable(), conf, ctx);
    }

    public static boolean isReplicated(Object pc, DistributedConfiguration conf) {
        return pc == null ? false : conf.isReplicated(pc.getClass());
    }

    public static boolean isSliceAssigned(OpenJPAStateManager sm) {
        return sm != null && sm.getImplData() != null && sm.getImplData() instanceof SliceInfo;
    }

    public static SliceInfo getSliceInfo(OpenJPAStateManager sm) {
        return SliceImplHelper.isSliceAssigned(sm) ? (SliceInfo)sm.getImplData() : null;
    }
}

