/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.iterator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public final class AbortiveMultiIterator<T>
implements Iterator<T>,
Serializable,
AutoCloseable {
    private final List<Iterator<T>> iterators = new ArrayList<Iterator<T>>();
    private final List<Predicate<Long>> checks = new ArrayList<Predicate<Long>>();
    private long counter = 0L;
    private int current = 0;

    public void addIterator(Iterator<T> iterator) {
        this.addIterator(iterator, c -> true);
    }

    public void addIterator(Iterator<T> iterator, Predicate<Long> check) {
        this.iterators.add(iterator);
        this.checks.add(check);
    }

    @Override
    public boolean hasNext() {
        if (this.current >= this.iterators.size()) {
            return false;
        }
        Iterator<T> currentIterator = this.iterators.get(this.current);
        while (true) {
            if (currentIterator.hasNext()) {
                return true;
            }
            ++this.current;
            if (this.current >= this.iterators.size() || !this.checks.get(this.current).test(this.counter)) break;
            currentIterator = this.iterators.get(this.current);
        }
        return false;
    }

    @Override
    public void remove() {
        this.iterators.get(this.current).remove();
    }

    @Override
    public T next() {
        if (this.iterators.isEmpty()) {
            throw FastNoSuchElementException.instance();
        }
        Iterator<T> currentIterator = this.iterators.get(this.current);
        while (true) {
            if (currentIterator.hasNext()) {
                ++this.counter;
                return currentIterator.next();
            }
            ++this.current;
            if (this.current >= this.iterators.size() || !this.checks.get(this.current).test(this.counter)) break;
            currentIterator = this.iterators.get(this.current);
        }
        throw FastNoSuchElementException.instance();
    }

    public void clear() {
        this.iterators.clear();
        this.checks.clear();
        this.counter = 0L;
        this.current = 0;
    }

    @Override
    public void close() {
        for (Iterator<T> iterator : this.iterators) {
            CloseableIterator.closeIterator(iterator);
        }
    }
}

