/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.PBiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.ConnectiveStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.IsStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NotStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class CountStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final Map<BiPredicate, Long> RANGE_PREDICATES = new HashMap<BiPredicate, Long>(){
        {
            this.put(Contains.within, 1L);
            this.put(Contains.without, 0L);
        }
    };
    private static final Set<Compare> INCREASED_OFFSET_SCALAR_PREDICATES = EnumSet.of(Compare.eq, Compare.neq, Compare.lte, Compare.gt);
    private static final CountStrategy INSTANCE = new CountStrategy();

    private CountStrategy() {
    }

    public static CountStrategy instance() {
        return INSTANCE;
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        TraversalParent parent = traversal.getParent();
        int size = traversal.getSteps().size();
        Step prev = null;
        for (int i = 0; i < size; ++i) {
            Step curr = traversal.getSteps().get(i);
            if (i < size - 1 && this.doStrategy(curr)) {
                IsStep isStep = (IsStep)traversal.getSteps().get(i + 1);
                P isStepPredicate = isStep.getPredicate();
                Long highRange = null;
                boolean useNotStep = false;
                boolean dismissCountIs = false;
                boolean hasGtOrLtNegative = false;
                for (P<Object> p : isStepPredicate instanceof ConnectiveP ? ((ConnectiveP)isStepPredicate).getPredicates() : Collections.singletonList(isStepPredicate)) {
                    Object high;
                    boolean update;
                    Long highRangeCandidate;
                    Object value = p.getValue();
                    PBiPredicate<Object, Object> predicate = p.getBiPredicate();
                    if (value instanceof Number) {
                        long highRangeOffset = INCREASED_OFFSET_SCALAR_PREDICATES.contains(predicate) ? 1L : 0L;
                        highRangeCandidate = (long)Math.ceil(((Number)value).doubleValue()) + highRangeOffset;
                        if ((predicate.equals(Compare.gt) || predicate.equals(Compare.gte) || predicate.equals(Compare.lt) || predicate.equals(Compare.lte)) && highRangeCandidate < 1L) {
                            hasGtOrLtNegative = true;
                        }
                        boolean bl = update = highRange == null || highRangeCandidate > highRange;
                        if (update) {
                            if (parent instanceof EmptyStep) {
                                useNotStep = false;
                            } else if (parent instanceof RepeatStep) {
                                RepeatStep repeatStep = (RepeatStep)parent;
                                useNotStep = Objects.equals(traversal, repeatStep.getUntilTraversal()) || Objects.equals(traversal, repeatStep.getEmitTraversal());
                                dismissCountIs = useNotStep;
                            } else {
                                useNotStep = parent instanceof FilterStep || parent instanceof SideEffectStep;
                                dismissCountIs = useNotStep;
                            }
                            highRange = highRangeCandidate;
                            useNotStep &= curr.getLabels().isEmpty() && isStep.getLabels().isEmpty() && isStep.getNextStep() instanceof EmptyStep && (highRange <= 1L && predicate.equals(Compare.lt) || highRange == 1L && (predicate.equals(Compare.eq) || predicate.equals(Compare.lte)));
                            dismissCountIs &= curr.getLabels().isEmpty() && isStep.getLabels().isEmpty() && isStep.getNextStep() instanceof EmptyStep && highRange == 1L && (predicate.equals(Compare.gt) || predicate.equals(Compare.gte));
                        }
                        if (!hasGtOrLtNegative) continue;
                        useNotStep = false;
                        dismissCountIs = false;
                        continue;
                    }
                    Long highRangeOffset = RANGE_PREDICATES.get(predicate);
                    if (!(value instanceof Collection) || highRangeOffset == null || !((high = Collections.max((Collection)value)) instanceof Number)) continue;
                    highRangeCandidate = ((Number)high).longValue() + highRangeOffset;
                    update = highRange == null || highRangeCandidate > highRange;
                    if (!update) continue;
                    highRange = highRangeCandidate;
                }
                if (highRange != null) {
                    if (useNotStep || dismissCountIs) {
                        Step<?, ?> parentStep;
                        traversal.asAdmin().removeStep(isStep);
                        traversal.asAdmin().removeStep(curr);
                        size -= 2;
                        if (!dismissCountIs) {
                            if (parent instanceof ConnectiveStep) {
                                Step<?, ?> notStep = this.transformToNotStep(traversal, parent);
                                TraversalHelper.removeAllSteps(traversal);
                                traversal.addStep(notStep);
                            } else if (parent instanceof FilterStep) {
                                Step<?, ?> filterStep = parent.asStep();
                                Step<?, ?> notStep = this.transformToNotStep(traversal, parent);
                                TraversalHelper.replaceStep(filterStep, notStep, filterStep.getTraversal());
                            } else {
                                Traversal.Admin inner;
                                if (prev != null) {
                                    inner = __.start().asAdmin();
                                    while (true) {
                                        Step pp = prev.getPreviousStep();
                                        inner.addStep(0, prev);
                                        if (!(pp instanceof EmptyStep) && !(pp instanceof GraphStep) && (prev instanceof FilterStep || prev instanceof SideEffectStep)) {
                                            traversal.removeStep(prev);
                                            prev = pp;
                                            --size;
                                            continue;
                                        }
                                        break;
                                    }
                                } else {
                                    inner = __.identity().asAdmin();
                                }
                                if (prev != null) {
                                    TraversalHelper.replaceStep(prev, new NotStep(traversal, inner), traversal);
                                } else {
                                    traversal.asAdmin().addStep(new NotStep(traversal, inner));
                                }
                            }
                        } else if (size == 0 && !((parentStep = traversal.getParent().asStep()) instanceof EmptyStep)) {
                            Traversal.Admin parentTraversal = parentStep.getTraversal();
                            TraversalHelper.replaceStep(parentStep, new IdentityStep(parentTraversal), parentTraversal);
                        }
                    } else {
                        TraversalHelper.insertBeforeStep(new RangeGlobalStep(traversal, 0L, highRange < 0L ? 0L : highRange), curr, traversal);
                    }
                    ++i;
                }
            }
            prev = curr;
        }
    }

    private Step<?, ?> transformToNotStep(Traversal.Admin<?, ?> traversal, TraversalParent parent) {
        Step<?, ?> filterStep = parent.asStep();
        Traversal.Admin parentTraversal = filterStep.getTraversal();
        NotStep notStep = new NotStep(parentTraversal, traversal.getSteps().isEmpty() ? __.identity() : traversal.clone());
        filterStep.getLabels().forEach(notStep::addLabel);
        return notStep;
    }

    private boolean doStrategy(Step step) {
        if (!(step instanceof CountGlobalStep) || !(step.getNextStep() instanceof IsStep) || step.getPreviousStep() instanceof RangeGlobalStep) {
            return false;
        }
        Step<?, ?> parent = step.getTraversal().getParent().asStep();
        return !(!(parent instanceof FilterStep) && !parent.getLabels().isEmpty() || parent.getNextStep() instanceof MatchStep.MatchEndStep && ((MatchStep.MatchEndStep)parent.getNextStep()).getMatchKey().isPresent());
    }
}

