/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.spring;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringTransactionInterceptor
extends AbstractCommandInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringTransactionInterceptor.class);
    protected PlatformTransactionManager transactionManager;

    public SpringTransactionInterceptor(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public <T> T execute(CommandConfig config, Command<T> command, CommandExecutor commandExecutor) {
        LOGGER.debug("Running command with propagation {}", (Object)config.getTransactionPropagation());
        int transactionPropagation = this.getPropagation(config);
        if (transactionPropagation == 0 && TransactionSynchronizationManager.isActualTransactionActive()) {
            return (T)this.next.execute(config, command, commandExecutor);
        }
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setPropagationBehavior(transactionPropagation);
        return (T)transactionTemplate.execute(status -> this.next.execute(config, command, commandExecutor));
    }

    private int getPropagation(CommandConfig config) {
        switch (config.getTransactionPropagation()) {
            case NOT_SUPPORTED: {
                return 4;
            }
            case REQUIRED: {
                return 0;
            }
            case REQUIRES_NEW: {
                return 3;
            }
        }
        throw new FlowableIllegalArgumentException("Unsupported transaction propagation: " + String.valueOf(config.getTransactionPropagation()));
    }
}

