/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class SaslXoauth2Message {
    private final String username;
    private final String accessToken;

    public SaslXoauth2Message(String username, String accessToken) {
        if (username == null || accessToken == null) {
            throw new IllegalArgumentException("Username and access token must not be null");
        }
        this.username = username;
        this.accessToken = accessToken;
    }

    public String getUsername() {
        return this.username;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public static SaslXoauth2Message parseBase64Encoded(String message) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(message);
            String decodedString = new String(decodedBytes, StandardCharsets.UTF_8);
            return SaslXoauth2Message.parse(decodedString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid Base64 or malformed input: " + e.getMessage());
        }
    }

    public static SaslXoauth2Message parse(String message) {
        try {
            String[] parts = message.split("\\u0001");
            if (parts.length > 2 || !parts[0].startsWith("user=") || !parts[1].startsWith("auth=Bearer ")) {
                throw new IllegalArgumentException("Invalid authentication string format");
            }
            return new SaslXoauth2Message(parts[0].substring(5), parts[1].substring(12));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid Base64 or malformed input: " + e.getMessage());
        }
    }
}

