/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.util;

import java.nio.charset.Charset;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.View;
import org.thymeleaf.util.ContentTypeUtils;
import org.thymeleaf.web.IWebExchange;

public final class SpringContentTypeUtils {
    public static String computeViewContentType(IWebExchange webExchange, String defaultContentType, Charset defaultCharset) {
        if (webExchange == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        MediaType negotiatedMediaType = (MediaType)webExchange.getAttributeValue(View.SELECTED_CONTENT_TYPE);
        if (negotiatedMediaType != null && negotiatedMediaType.isConcrete()) {
            Charset negotiatedCharset = negotiatedMediaType.getCharset();
            if (negotiatedCharset != null) {
                return negotiatedMediaType.toString();
            }
            return ContentTypeUtils.combineContentTypeAndCharset((String)negotiatedMediaType.toString(), (Charset)defaultCharset);
        }
        String combinedContentType = ContentTypeUtils.combineContentTypeAndCharset((String)defaultContentType, (Charset)defaultCharset);
        Charset combinedCharset = ContentTypeUtils.computeCharsetFromContentType((String)combinedContentType);
        String requestPathContentType = ContentTypeUtils.computeContentTypeForRequestPath((String)webExchange.getRequest().getRequestPath(), (Charset)combinedCharset);
        if (requestPathContentType != null) {
            return requestPathContentType;
        }
        return combinedContentType;
    }

    private SpringContentTypeUtils() {
    }
}

