/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.openjpa.jdbc.schema.DriverDataSource;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.jdbc.ConnectionDecorator;
import org.apache.openjpa.lib.jdbc.DelegatingDataSource;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.StoreException;

public class SimpleDriverDataSource
implements DriverDataSource {
    private String _connectionDriverName;
    private String _connectionURL;
    private String _connectionUserName;
    private String _connectionPassword;
    private Properties _connectionProperties;
    private Properties _connectionFactoryProperties;
    private Driver _driver;
    private ClassLoader _classLoader;
    protected static Localizer _loc = Localizer.forPackage(SimpleDriverDataSource.class);
    protected static Localizer _eloc = Localizer.forPackage(DelegatingDataSource.class);

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties props = new Properties();
        if (username == null) {
            username = this._connectionUserName;
        }
        if (username != null) {
            props.put("user", username);
        }
        if (password == null) {
            password = this._connectionPassword;
        }
        if (password != null) {
            props.put("password", password);
        }
        return this.getConnection(props);
    }

    public Connection getConnection(Properties props) throws SQLException {
        return this.getSimpleConnection(props);
    }

    protected Connection getSimpleConnection(Properties props) throws SQLException {
        Connection con;
        Properties conProps = new Properties();
        if (props != null) {
            conProps.putAll((Map<?, ?>)props);
        }
        if (this._connectionProperties != null) {
            conProps.putAll((Map<?, ?>)this._connectionProperties);
        }
        if ((con = this.getSimpleDriver().connect(this._connectionURL, conProps)) == null) {
            throw new SQLException(_eloc.get("poolds-null", this._connectionDriverName, this._connectionURL).getMessage());
        }
        return con;
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public void setLoginTimeout(int seconds) {
    }

    @Override
    public PrintWriter getLogWriter() {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public void initDBDictionary(DBDictionary dict) {
    }

    @Override
    public void setConnectionURL(String connectionURL) {
        this._connectionURL = connectionURL;
    }

    @Override
    public String getConnectionURL() {
        return this._connectionURL;
    }

    @Override
    public void setConnectionUserName(String connectionUserName) {
        this._connectionUserName = connectionUserName;
    }

    @Override
    public String getConnectionUserName() {
        return this._connectionUserName;
    }

    @Override
    public void setConnectionPassword(String connectionPassword) {
        this._connectionPassword = connectionPassword;
    }

    protected String getConnectionPassword() {
        return this._connectionPassword;
    }

    @Override
    public void setConnectionProperties(Properties props) {
        this._connectionProperties = props;
    }

    @Override
    public Properties getConnectionProperties() {
        return this._connectionProperties;
    }

    @Override
    public void setConnectionFactoryProperties(Properties props) {
        this._connectionFactoryProperties = props;
    }

    @Override
    public Properties getConnectionFactoryProperties() {
        return this._connectionFactoryProperties;
    }

    @Override
    public List<ConnectionDecorator> createConnectionDecorators() {
        return null;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public void setConnectionDriverName(String connectionDriverName) {
        this._connectionDriverName = connectionDriverName;
    }

    @Override
    public String getConnectionDriverName() {
        return this._connectionDriverName;
    }

    protected Driver getSimpleDriver() {
        if (this._driver != null) {
            return this._driver;
        }
        try {
            this._driver = DriverManager.getDriver(this._connectionURL);
            if (this._driver != null) {
                return this._driver;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class.forName(this._connectionDriverName, true, this._classLoader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this._driver = DriverManager.getDriver(this._connectionURL);
            if (this._driver != null) {
                return this._driver;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class<?> c = Class.forName(this._connectionDriverName, true, this._classLoader);
            this._driver = (Driver)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(c));
            return this._driver;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            throw new StoreException(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(SimpleDriverDataSource.class);
    }

    public Object unwrap(Class iface) {
        if (this.isWrapperFor(iface)) {
            return this;
        }
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

