/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.minikdc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.function.BiConsumer;
import kafka.security.minikdc.MiniKdc;
import kafka.utils.Exit$;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class MiniKdc$ {
    public static final MiniKdc$ MODULE$ = new MiniKdc$();
    private static final String JavaSecurityKrb5Conf = "java.security.krb5.conf";
    private static final String SunSecurityKrb5Debug = "sun.security.krb5.debug";
    private static final String OrgName = "org.name";
    private static final String OrgDomain = "org.domain";
    private static final String KdcBindAddress = "kdc.bind.address";
    private static final String KdcPort = "kdc.port";
    private static final String Instance = "instance";
    private static final String MaxTicketLifetime = "max.ticket.lifetime";
    private static final String MaxRenewableLifetime = "max.renewable.lifetime";
    private static final String Transport = "transport";
    private static final String Debug = "debug";
    private static final Set<String> kafka$security$minikdc$MiniKdc$$RequiredProperties = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.OrgName(), MODULE$.OrgDomain(), MODULE$.KdcBindAddress(), MODULE$.KdcPort(), MODULE$.Instance(), MODULE$.Transport(), MODULE$.MaxTicketLifetime(), MODULE$.MaxRenewableLifetime()}));
    private static final Map<String, String> DefaultConfig = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.KdcBindAddress()), (Object)"localhost"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.KdcPort()), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.Instance()), (Object)"DefaultKrbServer"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.OrgName()), (Object)"Example"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.OrgDomain()), (Object)"COM"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.Transport()), (Object)"TCP"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.MaxTicketLifetime()), (Object)"86400000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.MaxRenewableLifetime()), (Object)"604800000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.Debug()), (Object)"false")}));

    public String JavaSecurityKrb5Conf() {
        return JavaSecurityKrb5Conf;
    }

    public String SunSecurityKrb5Debug() {
        return SunSecurityKrb5Debug;
    }

    public void main(String[] args) {
        Object object;
        if (args != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)args))) {
            new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object));
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) >= 0) {
                String workDirPath = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String configPath = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                String keytabPath = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
                Seq principals = Array.UnapplySeqWrapper$.MODULE$.drop$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3);
                if (principals.nonEmpty()) {
                    File workDir = new File(workDirPath);
                    if (!workDir.exists()) {
                        throw new RuntimeException(new StringBuilder(41).append("Specified work directory does not exist: ").append(workDir.getAbsolutePath()).toString());
                    }
                    Properties config = this.createConfig();
                    File configFile = new File(configPath);
                    if (!configFile.exists()) {
                        throw new RuntimeException(new StringBuilder(40).append("Specified configuration does not exist: ").append(configFile.getAbsolutePath()).toString());
                    }
                    Utils.loadProps((String)configFile.getAbsolutePath(), null).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> config.put(key, value)));
                    File keytabFile = new File(keytabPath).getAbsoluteFile();
                    this.start(workDir, config, keytabFile, (Seq<String>)principals);
                    return;
                }
            }
        }
        Predef$.MODULE$.println((Object)"Arguments: <WORKDIR> <MINIKDCPROPERTIES> <KEYTABFILE> [<PRINCIPALS>]+");
        throw Exit$.MODULE$.exit(1, (Option)None$.MODULE$);
    }

    public MiniKdc start(File workDir, Properties config, File keytabFile, Seq<String> principals) {
        MiniKdc miniKdc = new MiniKdc(config, workDir);
        miniKdc.start();
        miniKdc.createPrincipal(keytabFile, principals);
        String infoMessage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n      |\n      |Standalone MiniKdc Running\n      |---------------------------------------------------\n      |  Realm           : ").append(miniKdc.kafka$security$minikdc$MiniKdc$$realm()).append("\n      |  Running at      : ").append(miniKdc.host()).append(":").append(miniKdc.port()).append("\n      |  krb5conf        : ").append(miniKdc.kafka$security$minikdc$MiniKdc$$krb5conf()).append("\n      |\n      |  created keytab  : ").append(keytabFile).append("\n      |  with principals : ").append(principals.mkString(", ")).append("\n      |\n      |Hit <CTRL-C> or kill <PID> to stop it\n      |---------------------------------------------------\n      |\n    ").toString()));
        Predef$.MODULE$.println((Object)infoMessage);
        Exit.addShutdownHook((String)"minikdc-shutdown-hook", () -> Exit$.$anonfun$addShutdownHook$1((Function0)(JFunction0.mcV.sp & Serializable)() -> miniKdc.stop()));
        return miniKdc;
    }

    public String OrgName() {
        return OrgName;
    }

    public String OrgDomain() {
        return OrgDomain;
    }

    public String KdcBindAddress() {
        return KdcBindAddress;
    }

    public String KdcPort() {
        return KdcPort;
    }

    public String Instance() {
        return Instance;
    }

    public String MaxTicketLifetime() {
        return MaxTicketLifetime;
    }

    public String MaxRenewableLifetime() {
        return MaxRenewableLifetime;
    }

    public String Transport() {
        return Transport;
    }

    public String Debug() {
        return Debug;
    }

    public Set<String> kafka$security$minikdc$MiniKdc$$RequiredProperties() {
        return kafka$security$minikdc$MiniKdc$$RequiredProperties;
    }

    private Map<String, String> DefaultConfig() {
        return DefaultConfig;
    }

    public Properties createConfig() {
        Properties properties = new Properties();
        this.DefaultConfig().foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return properties.setProperty(k, v);
            }
            throw new MatchError(null);
        });
        return properties;
    }

    public InputStream getResourceAsStream(String resourceName) throws IOException {
        ClassLoader cl = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0 & Serializable)() -> MiniKdc.class.getClassLoader());
        return (InputStream)Option$.MODULE$.apply((Object)cl.getResourceAsStream(resourceName)).getOrElse((Function0 & Serializable)() -> {
            throw new IOException(new StringBuilder(29).append("Can not read resource file `").append(resourceName).append("`").toString());
        });
    }

    private MiniKdc$() {
    }
}

