/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus.TempusDominusIconConfig;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class TempusDominusDisplayConfig
extends AbstractConfig {
    private static final long serialVersionUID = 1L;
    private static final IKey<TempusDominusIconConfig> Icons = TempusDominusDisplayConfig.newKey((String)"icons", null);
    private static final IKey<Boolean> SideBySide = TempusDominusDisplayConfig.newKey((String)"sideBySide", (Object)false);
    private static final IKey<Boolean> CalendarWeeks = TempusDominusDisplayConfig.newKey((String)"calendarWeeks", (Object)false);
    private static final IKey<String> ViewMode = TempusDominusDisplayConfig.newKey((String)"viewMode", null);
    private static final IKey<String> ToolbarPlacement = TempusDominusDisplayConfig.newKey((String)"toolbarPlacement", null);
    private static final IKey<Boolean> KeepOpen = TempusDominusDisplayConfig.newKey((String)"keepOpen", (Object)false);
    private static final IKey<Map<String, Boolean>> Buttons = TempusDominusDisplayConfig.newKey((String)"buttons", null);
    private static final IKey<Map<String, Boolean>> Components = TempusDominusDisplayConfig.newKey((String)"components", null);
    private static final IKey<Boolean> Inline = TempusDominusDisplayConfig.newKey((String)"inline", (Object)false);
    private static final IKey<String> Theme = TempusDominusDisplayConfig.newKey((String)"theme", null);

    public TempusDominusDisplayConfig() {
        this.put(Icons, (Object)new TempusDominusIconConfig());
        this.put(Buttons, new HashMap(3));
        this.put(Components, new HashMap(9));
    }

    public <T extends Temporal> TempusDominusDisplayConfig withClass(Class<T> clazz) {
        if (LocalTime.class == clazz) {
            this.withComponent(ComponentType.CALENDAR, false);
            this.withViewMode(ViewModeType.CLOCK);
        } else if (LocalDate.class == clazz) {
            this.withComponent(ComponentType.CLOCK, false);
        }
        return this;
    }

    public TempusDominusDisplayConfig withIcons(Consumer<TempusDominusIconConfig> cfgUpdater) {
        cfgUpdater.accept((TempusDominusIconConfig)((Object)this.get(Icons)));
        return this;
    }

    public TempusDominusDisplayConfig withSideBySide(boolean sideBySide) {
        this.put(SideBySide, sideBySide);
        return this;
    }

    public TempusDominusDisplayConfig withCalendarWeeks(boolean calendarWeeks) {
        this.put(CalendarWeeks, calendarWeeks);
        return this;
    }

    public TempusDominusDisplayConfig withViewMode(ViewModeType view) {
        this.put(ViewMode, view.getCode());
        return this;
    }

    public TempusDominusDisplayConfig withToolbarPlacement(ToolbarPlacementType place) {
        this.put(ToolbarPlacement, place.getPlacement());
        return this;
    }

    public TempusDominusDisplayConfig withKeepOpen(boolean keep) {
        this.put(KeepOpen, keep);
        return this;
    }

    public TempusDominusDisplayConfig withButton(ButtonType type, boolean value) {
        ((Map)this.get(Buttons)).put(type.getType(), value);
        return this;
    }

    public TempusDominusDisplayConfig withComponent(ComponentType cmp, boolean on) {
        ((Map)this.get(Components)).put(cmp.getComponent(), on);
        return this;
    }

    public TempusDominusDisplayConfig withInline(boolean inline) {
        this.put(Inline, inline);
        return this;
    }

    public TempusDominusDisplayConfig withTheme(ThemeType theme) {
        this.put(Theme, theme.getTheme());
        return this;
    }

    public static enum ComponentType {
        CALENDAR("calendar"),
        DATE("date"),
        MONTH("month"),
        YEAR("year"),
        DECADES("decades"),
        CLOCK("clock"),
        HOURS("hours"),
        MINUTES("minutes"),
        SECONDS("seconds");

        private final String component;

        private ComponentType(String component) {
            this.component = component;
        }

        public String getComponent() {
            return this.component;
        }
    }

    public static enum ViewModeType {
        CLOCK("clock"),
        CALENDAR("calendar"),
        MONTHS("months"),
        YEARS("years"),
        DECADES("decades");

        private final String code;

        private ViewModeType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum ToolbarPlacementType {
        TOP("top"),
        BOTTOM("bottom");

        private final String placement;

        private ToolbarPlacementType(String placement) {
            this.placement = placement;
        }

        public String getPlacement() {
            return this.placement;
        }
    }

    public static enum ButtonType {
        TODAY("today"),
        CLEAR("clear"),
        CLOSE("close");

        private final String type;

        private ButtonType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static enum ThemeType {
        LIGHT("light"),
        DARK("dark"),
        AUTO("auto");

        private final String theme;

        private ThemeType(String theme) {
            this.theme = theme;
        }

        public String getTheme() {
            return this.theme;
        }
    }
}

