/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope.pm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.syncope.BaseSyncopeSearchProperties;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.impl.BasePasswordManagementService;
import org.apereo.cas.syncope.SyncopeUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class SyncopePasswordManagementService
extends BasePasswordManagementService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncopePasswordManagementService.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();

    public SyncopePasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, CasConfigurationProperties casProperties, PasswordHistoryService passwordHistoryService) {
        super(casProperties, cipherExecutor, passwordHistoryService);
    }

    public boolean changeInternal(PasswordChangeRequest bean) {
        return (Boolean)FunctionUtils.doAndHandle(() -> {
            String syncopeRestPasswordResetUrl = StringUtils.appendIfMissing((String)SpringExpressionLanguageValueResolver.getInstance().resolve(this.casProperties.getAuthn().getPm().getSyncope().getUrl()), (CharSequence)"/rest/users/self/mustChangePassword", (CharSequence[])new CharSequence[0]);
            LOGGER.debug("Updating account password on syncope for user [{}]", (Object)bean.getUsername());
            HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.POST).url(syncopeRestPasswordResetUrl).basicAuthUsername(bean.getUsername()).basicAuthPassword(bean.toCurrentPassword()).headers(Map.of("X-Syncope-Domain", this.casProperties.getAuthn().getSyncope().getDomain(), "Accept", "application/json", "Content-Type", "application/json")).entity(MAPPER.writeValueAsString((Object)this.getPasswordPatch(bean))).maximumRetryAttempts(this.casProperties.getAuthn().getSyncope().getMaxRetryAttempts()).build();
            HttpResponse response = Objects.requireNonNull(HttpUtils.execute((HttpExecutionRequest)exec));
            if (response.getCode() == 200) {
                LOGGER.debug("Successfully updated the account password on Syncope for [{}]", (Object)bean.getUsername());
                return true;
            }
            return false;
        }, e -> {
            LOGGER.error("Error while update password on Syncope for user [{}]", (Object)bean.getUsername());
            return false;
        }).get();
    }

    public String findEmail(PasswordManagementQuery query) {
        return this.getUserAttribute(query, "email").orElseGet(() -> ((PasswordManagementQuery)query).getEmail());
    }

    public String findPhone(PasswordManagementQuery query) {
        return this.getUserAttribute(query, "phoneNumber").orElseGet(() -> ((PasswordManagementQuery)query).getPhoneNumber());
    }

    public String findUsername(PasswordManagementQuery query) {
        return this.getUserAttribute(query, "username").orElseGet(() -> ((PasswordManagementQuery)query).getUsername());
    }

    public Map<String, String> getSecurityQuestions(PasswordManagementQuery query) {
        throw new UnsupportedOperationException("Password Management Service does not support security questions");
    }

    public void updateSecurityQuestions(PasswordManagementQuery query) {
        throw new UnsupportedOperationException("Password Management Service does not support updating security questions");
    }

    public boolean unlockAccount(Credential credential) {
        throw new UnsupportedOperationException("Password Management Service does not support unlocking of accounts");
    }

    protected Optional<String> getUserAttribute(PasswordManagementQuery query, String attributeName) {
        return this.searchUser(query).stream().findFirst().map(syncopeUser -> {
            String prefix = "%s_%s".formatted("syncopeUserAttr", attributeName);
            return syncopeUser.getOrDefault(attributeName, (List)syncopeUser.get(prefix));
        }).filter(Objects::nonNull).filter(values -> !values.isEmpty()).map(values -> values.getFirst().toString());
    }

    private List<Map<String, List<Object>>> searchUser(PasswordManagementQuery query) {
        return SyncopeUtils.syncopeUserSearch((BaseSyncopeSearchProperties)this.casProperties.getAuthn().getPm().getSyncope(), query.getUsername());
    }

    private JsonNode getPasswordPatch(PasswordChangeRequest bean) {
        ObjectNode passwordPatch = MAPPER.createObjectNode();
        passwordPatch.put("operation", "ADD_REPLACE");
        passwordPatch.put("value", bean.toConfirmedPassword());
        passwordPatch.put("onSyncope", true);
        ArrayNode resources = MAPPER.createArrayNode();
        passwordPatch.set("resources", (JsonNode)resources);
        return passwordPatch;
    }
}

