/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.Wrapped;
import org.reactivestreams.Publisher;

public class OptionsCapableConnectionFactory
implements Wrapped<ConnectionFactory>,
ConnectionFactory {
    private final ConnectionFactoryOptions options;
    private final ConnectionFactory delegate;

    public OptionsCapableConnectionFactory(ConnectionFactoryOptions options, ConnectionFactory delegate) {
        this.options = options;
        this.delegate = delegate;
    }

    public ConnectionFactoryOptions getOptions() {
        return this.options;
    }

    public Publisher<? extends Connection> create() {
        return this.delegate.create();
    }

    public ConnectionFactoryMetadata getMetadata() {
        return this.delegate.getMetadata();
    }

    public ConnectionFactory unwrap() {
        return this.delegate;
    }

    public static OptionsCapableConnectionFactory unwrapFrom(ConnectionFactory connectionFactory) {
        Wrapped wrappedConnectionFactory;
        Object unwrapped;
        if (connectionFactory instanceof OptionsCapableConnectionFactory) {
            OptionsCapableConnectionFactory optionsCapableConnectionFactory = (OptionsCapableConnectionFactory)connectionFactory;
            return optionsCapableConnectionFactory;
        }
        if (connectionFactory instanceof Wrapped && (unwrapped = (wrappedConnectionFactory = (Wrapped)connectionFactory).unwrap()) instanceof ConnectionFactory) {
            ConnectionFactory unwrappedConnectionFactory = (ConnectionFactory)unwrapped;
            return OptionsCapableConnectionFactory.unwrapFrom(unwrappedConnectionFactory);
        }
        return null;
    }
}

