/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import lombok.Generated;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.OAuth20PasswordGrantTypeTokenRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20ClientCredentialsGrantTypeTokenRequestValidator
extends OAuth20PasswordGrantTypeTokenRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ClientCredentialsGrantTypeTokenRequestValidator.class);

    public OAuth20ClientCredentialsGrantTypeTokenRequestValidator(OAuth20ConfigurationContext configurationContext) {
        super(configurationContext);
    }

    @Override
    public boolean supports(WebContext context) {
        OAuth20RequestParameterResolver requestParameterResolver = this.getConfigurationContext().getRequestParameterResolver();
        String grantType = requestParameterResolver.resolveRequestParameter(context, "grant_type").map(String::valueOf).orElse("");
        return OAuth20Utils.isGrantType(grantType, OAuth20GrantTypes.CLIENT_CREDENTIALS);
    }

    @Override
    protected OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.CLIENT_CREDENTIALS;
    }
}

