/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.resources.oidcc4ui;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.client.ui.commons.annotations.Resource;
import org.apache.syncope.common.lib.oidc.OIDCRequest;
import org.apache.syncope.common.rest.api.service.OIDCC4UIService;
import org.apache.wicket.Session;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

@Resource(key="oidcc4ui.beforeLogout", path="/oidcc4ui/before-logout")
public class BeforeLogoutResource
extends AbstractResource {
    private static final long serialVersionUID = 273797583932923564L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
        String postLogoutRedirectURI = StringUtils.substringBefore((String)request.getRequestURL().toString(), (String)"/before-logout") + "/logout";
        OIDCC4UIService service = (OIDCC4UIService)((BaseSession)BaseSession.class.cast(Session.get())).getService(OIDCC4UIService.class);
        OIDCRequest logoutRequest = service.createLogoutRequest(postLogoutRedirectURI);
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setStatusCode(Integer.valueOf(Response.Status.FOUND.getStatusCode()));
        response.getHeaders().addHeader("Cache-Control", "no-cache, no-store");
        response.getHeaders().addHeader("Pragma", "no-cache");
        response.getHeaders().addHeader("Location", logoutRequest.getLocation());
        Session.get().invalidate();
        return response;
    }
}

