/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.internals.RequestState;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RequestStateTest {
    @Test
    public void testRequestStateSimple() {
        RequestState state = new RequestState(new LogContext(), this.getClass().getSimpleName(), 100L, 2, 1000L, 0.0);
        Assertions.assertTrue((boolean)state.canSendRequest(0L));
        state.onSendAttempt(0L);
        Assertions.assertFalse((boolean)state.canSendRequest(0L));
        state.onFailedAttempt(35L);
        Assertions.assertTrue((boolean)state.canSendRequest(135L));
        state.onFailedAttempt(140L);
        Assertions.assertFalse((boolean)state.canSendRequest(200L));
        Assertions.assertTrue((boolean)state.canSendRequest(340L));
        state.reset();
        Assertions.assertTrue((boolean)state.canSendRequest(200L));
    }

    @Test
    public void testTrackInflightOnSuccessfulAttempt() {
        this.testTrackInflight(RequestState::onSuccessfulAttempt);
    }

    @Test
    public void testTrackInflightOnFailedAttempt() {
        this.testTrackInflight(RequestState::onFailedAttempt);
    }

    private void testTrackInflight(BiConsumer<RequestState, Integer> onCompletedAttempt) {
        RequestState state = new RequestState(new LogContext(), this.getClass().getSimpleName(), 100L, 2, 1000L, 0.0);
        Assertions.assertFalse((boolean)state.requestInFlight());
        state.onSendAttempt(202L);
        Assertions.assertTrue((boolean)state.requestInFlight());
        onCompletedAttempt.accept(state, 236);
        Assertions.assertFalse((boolean)state.requestInFlight());
        state.onSendAttempt(236L);
        Assertions.assertTrue((boolean)state.requestInFlight());
    }
}

