/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.content;

import jakarta.xml.bind.DatatypeConverter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.syncope.core.persistence.api.utils.FormatUtils;
import org.apache.syncope.core.persistence.common.content.AbstractContentLoaderHandler;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.xml.sax.Attributes;

public class ContentLoaderHandler
extends AbstractContentLoaderHandler {
    private final JdbcTemplate jdbcTemplate;

    public ContentLoaderHandler(DataSource dataSource, String rootElement, boolean continueOnError, Environment env) {
        super(rootElement, continueOnError, env);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    protected void fetch(Attributes atts) {
        String value = (String)this.jdbcTemplate.queryForObject(atts.getValue("query"), String.class);
        String key = atts.getValue("key");
        this.fetches.put(key, value);
    }

    private Object[] getParameters(String tableName, Attributes attrs) {
        Map colTypes = (Map)this.jdbcTemplate.query("SELECT * FROM " + tableName + " WHERE 0=1", rs -> {
            HashMap<String, Integer> types = new HashMap<String, Integer>();
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                types.put(rs.getMetaData().getColumnName(i).toUpperCase(), rs.getMetaData().getColumnType(i));
            }
            return types;
        });
        Object[] parameters = new Object[attrs.getLength()];
        block25: for (int i = 0; i < attrs.getLength(); ++i) {
            String value;
            Integer colType = (Integer)Objects.requireNonNull(colTypes).get(attrs.getQName(i).toUpperCase());
            if (colType == null) {
                LOG.warn("No column type found for {}", (Object)attrs.getQName(i).toUpperCase());
                colType = 12;
            }
            if ((value = this.paramSubstitutor.replace(attrs.getValue(i))) == null) {
                LOG.warn("Variable ${} could not be resolved", (Object)attrs.getValue(i));
                value = attrs.getValue(i);
            }
            value = StringEscapeUtils.unescapeXml((String)value);
            switch (colType) {
                case -6: 
                case 4: 
                case 5: {
                    try {
                        parameters[i] = Integer.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Integer '{}'", (Object)value);
                        parameters[i] = value;
                    }
                    continue block25;
                }
                case -5: 
                case 2: 
                case 3: {
                    try {
                        parameters[i] = Long.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Long '{}'", (Object)value);
                        parameters[i] = value;
                    }
                    continue block25;
                }
                case 8: {
                    try {
                        parameters[i] = Double.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Double '{}'", (Object)value);
                        parameters[i] = value;
                    }
                    continue block25;
                }
                case 6: 
                case 7: {
                    try {
                        parameters[i] = Float.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        LOG.error("Unparsable Float '{}'", (Object)value);
                        parameters[i] = value;
                    }
                    continue block25;
                }
                case -101: 
                case 91: 
                case 92: 
                case 93: 
                case 2014: {
                    try {
                        parameters[i] = FormatUtils.parseDate((String)value);
                    }
                    catch (DateTimeParseException e) {
                        LOG.error("Unparsable Date '{}'", (Object)value);
                        parameters[i] = value;
                    }
                    continue block25;
                }
                case -7: 
                case 16: {
                    parameters[i] = "1".equals(value) ? Boolean.TRUE : Boolean.FALSE;
                    continue block25;
                }
                case -4: 
                case -3: 
                case -2: {
                    try {
                        parameters[i] = DatatypeConverter.parseHexBinary((String)value);
                    }
                    catch (IllegalArgumentException e) {
                        parameters[i] = value;
                    }
                    continue block25;
                }
                case 2004: {
                    try {
                        parameters[i] = DatatypeConverter.parseHexBinary((String)value);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Error decoding hex string to specify a blob parameter", (Throwable)e);
                        parameters[i] = value;
                    }
                    catch (Exception e) {
                        LOG.warn("Error creating a new blob parameter", (Throwable)e);
                    }
                    continue block25;
                }
                default: {
                    parameters[i] = value;
                }
            }
        }
        return parameters;
    }

    protected void create(String qName, Attributes atts) {
        block3: {
            StringBuilder query = new StringBuilder("INSERT INTO ").append(qName).append('(');
            StringBuilder values = new StringBuilder();
            for (int i = 0; i < atts.getLength(); ++i) {
                query.append(atts.getQName(i));
                values.append('?');
                if (i >= atts.getLength() - 1) continue;
                query.append(',');
                values.append(',');
            }
            query.append(") VALUES (").append((CharSequence)values).append(')');
            try {
                this.jdbcTemplate.update(query.toString(), this.getParameters(qName, atts));
            }
            catch (DataAccessException e) {
                LOG.error("While trying to perform {} with params {}", new Object[]{query, this.getParameters(qName, atts), e});
                if (this.continueOnError) break block3;
                throw e;
            }
        }
    }
}

