/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.security.authorizer;

import java.net.InetAddress;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.Authorizer;

public class AuthorizerUtils {
    public static Authorizer createAuthorizer(String className) throws ClassNotFoundException {
        return (Authorizer)Utils.newInstance((String)className, Authorizer.class);
    }

    public static boolean isClusterResource(String name) {
        return name.equals("kafka-cluster");
    }

    public static AuthorizableRequestContext sessionToRequestContext(final Session session) {
        return new AuthorizableRequestContext(){

            public String clientId() {
                return "";
            }

            public int requestType() {
                return -1;
            }

            public String listenerName() {
                return "";
            }

            public InetAddress clientAddress() {
                return session.clientAddress;
            }

            public KafkaPrincipal principal() {
                return session.principal;
            }

            public SecurityProtocol securityProtocol() {
                return null;
            }

            public int correlationId() {
                return -1;
            }

            public int requestVersion() {
                return -1;
            }
        };
    }
}

