/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.security.authorizer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Json;
import org.apache.kafka.server.util.json.DecodeJson;
import org.apache.kafka.server.util.json.JsonObject;
import org.apache.kafka.server.util.json.JsonValue;

public class AclEntry
extends AccessControlEntry {
    private static final DecodeJson.DecodeInteger INT = new DecodeJson.DecodeInteger();
    private static final DecodeJson.DecodeString STRING = new DecodeJson.DecodeString();
    public static final KafkaPrincipal WILDCARD_PRINCIPAL = new KafkaPrincipal("User", "*");
    public static final String WILDCARD_PRINCIPAL_STRING = WILDCARD_PRINCIPAL.toString();
    public static final String WILDCARD_HOST = "*";
    public static final String WILDCARD_RESOURCE = "*";
    public static final String RESOURCE_SEPARATOR = ":";
    public static final Set<ResourceType> RESOURCE_TYPES = Arrays.stream(ResourceType.values()).filter(t -> t != ResourceType.UNKNOWN && t != ResourceType.ANY).collect(Collectors.toSet());
    public static final Set<AclOperation> ACL_OPERATIONS = Arrays.stream(AclOperation.values()).filter(t -> t != AclOperation.UNKNOWN && t != AclOperation.ANY).collect(Collectors.toSet());
    private static final String PRINCIPAL_KEY = "principal";
    private static final String PERMISSION_TYPE_KEY = "permissionType";
    private static final String OPERATION_KEY = "operation";
    private static final String HOSTS_KEY = "host";
    public static final String VERSION_KEY = "version";
    public static final int CURRENT_VERSION = 1;
    private static final String ACLS_KEY = "acls";
    public final AccessControlEntry ace;
    public final KafkaPrincipal kafkaPrincipal;

    public AclEntry(AccessControlEntry ace) {
        super(ace.principal(), ace.host(), ace.operation(), ace.permissionType());
        this.ace = ace;
        this.kafkaPrincipal = ace.principal() == null ? null : SecurityUtils.parseKafkaPrincipal((String)ace.principal());
    }

    public static Set<AclEntry> fromBytes(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return Collections.emptySet();
        }
        Optional jsonValue = Json.parseBytes((byte[])bytes);
        if (!jsonValue.isPresent()) {
            return Collections.emptySet();
        }
        JsonObject js = ((JsonValue)jsonValue.get()).asJsonObject();
        Utils.require(((Integer)js.apply(VERSION_KEY).to((DecodeJson)INT) == 1 ? 1 : 0) != 0);
        HashSet<AclEntry> res = new HashSet<AclEntry>();
        Iterator aclsIter = js.apply(ACLS_KEY).asJsonArray().iterator();
        while (aclsIter.hasNext()) {
            JsonObject itemJs = ((JsonValue)aclsIter.next()).asJsonObject();
            KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)((String)itemJs.apply(PRINCIPAL_KEY).to((DecodeJson)STRING)));
            AclPermissionType permissionType = SecurityUtils.permissionType((String)((String)itemJs.apply(PERMISSION_TYPE_KEY).to((DecodeJson)STRING)));
            String host = (String)itemJs.apply(HOSTS_KEY).to((DecodeJson)STRING);
            AclOperation operation = SecurityUtils.operation((String)((String)itemJs.apply(OPERATION_KEY).to((DecodeJson)STRING)));
            res.add(new AclEntry(new AccessControlEntry(principal.toString(), host, operation, permissionType)));
        }
        return res;
    }

    public static Map<String, Object> toJsonCompatibleMap(Set<AclEntry> acls) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put(VERSION_KEY, 1);
        res.put(ACLS_KEY, acls.stream().map(AclEntry::toMap).collect(Collectors.toList()));
        return res;
    }

    public static Set<AclOperation> supportedOperations(ResourceType resourceType) {
        switch (resourceType) {
            case TOPIC: {
                return new HashSet<AclOperation>(Arrays.asList(AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS));
            }
            case GROUP: {
                return new HashSet<AclOperation>(Arrays.asList(AclOperation.READ, AclOperation.DESCRIBE, AclOperation.DELETE));
            }
            case CLUSTER: {
                return new HashSet<AclOperation>(Arrays.asList(AclOperation.CREATE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.ALTER, AclOperation.DESCRIBE));
            }
            case TRANSACTIONAL_ID: {
                return new HashSet<AclOperation>(Arrays.asList(AclOperation.DESCRIBE, AclOperation.WRITE));
            }
            case DELEGATION_TOKEN: {
                return Collections.singleton(AclOperation.DESCRIBE);
            }
            case USER: {
                return new HashSet<AclOperation>(Arrays.asList(AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS));
            }
        }
        throw new IllegalArgumentException("Not a concrete resource type");
    }

    public static Errors authorizationError(ResourceType resourceType) {
        switch (resourceType) {
            case TOPIC: {
                return Errors.TOPIC_AUTHORIZATION_FAILED;
            }
            case GROUP: {
                return Errors.GROUP_AUTHORIZATION_FAILED;
            }
            case CLUSTER: {
                return Errors.CLUSTER_AUTHORIZATION_FAILED;
            }
            case TRANSACTIONAL_ID: {
                return Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED;
            }
            case DELEGATION_TOKEN: {
                return Errors.DELEGATION_TOKEN_AUTHORIZATION_FAILED;
            }
        }
        throw new IllegalArgumentException("Authorization error type not known");
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put(PRINCIPAL_KEY, this.principal());
        res.put(PERMISSION_TYPE_KEY, SecurityUtils.permissionTypeName((AclPermissionType)this.permissionType()));
        res.put(OPERATION_KEY, SecurityUtils.operationName((AclOperation)this.operation()));
        res.put(HOSTS_KEY, this.host());
        return res;
    }

    public int hashCode() {
        return this.ace.hashCode();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String toString() {
        return String.format("%s has %s permission for operations: %s from hosts: %s", this.principal(), this.permissionType().name(), this.operation(), this.host());
    }
}

