/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderAbsentException;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class OidcMultifactorAuthenticationTrigger
implements MultifactorAuthenticationTrigger {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcMultifactorAuthenticationTrigger.class);
    private final CasConfigurationProperties casProperties;
    private final MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver;
    private final ApplicationContext applicationContext;
    private final OAuth20RequestParameterResolver oauthRequestParameterResolver;
    private final FactoryBean<OidcServerDiscoverySettings> discoverySettingsFactory;
    private int order = Integer.MAX_VALUE;

    public Optional<MultifactorAuthenticationProvider> isActivated(Authentication authentication, RegisteredService registeredService, HttpServletRequest request, HttpServletResponse response, Service service) {
        String acr = this.getAuthenticationClassReference(request, response);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)acr)) {
            LOGGER.debug("No ACR provided in the authentication request");
            return Optional.empty();
        }
        Set<String> supportedAcrValues = this.getSupportedAcrValues(authentication, registeredService, request);
        List<String> values = List.of(StringUtils.delimitedListToStringArray((String)acr, (String)" "));
        if (values.stream().noneMatch(supportedAcrValues::contains)) {
            LOGGER.warn("ACR [{}] is not defined as a supported ACR in CAS configuration, [{}]", (Object)acr, supportedAcrValues);
            return Optional.empty();
        }
        Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        if (providerMap.isEmpty()) {
            LOGGER.error("No multifactor authentication providers are available in the application context to handle [{}]", values);
            throw new AuthenticationException((Throwable)new MultifactorAuthenticationProviderAbsentException());
        }
        List authnContexts = this.casProperties.getAuthn().getOidc().getCore().getAuthenticationContextReferenceMappings();
        Map mappings = CollectionUtils.convertDirectedListToMap((Collection)authnContexts);
        List mappedAcrValues = values.stream().map(acrValue -> mappings.getOrDefault(acrValue, acrValue)).collect(Collectors.toList());
        LOGGER.debug("Mapped ACR values are [{}] to compare against [{}]", mappedAcrValues, providerMap.values());
        return providerMap.values().stream().filter(v -> mappedAcrValues.contains(v.getId())).findAny();
    }

    protected Set<String> getSupportedAcrValues(Authentication authentication, RegisteredService registeredService, HttpServletRequest request) {
        return (Set)FunctionUtils.doUnchecked(() -> ((OidcServerDiscoverySettings)this.discoverySettingsFactory.getObject()).getAcrValuesSupported());
    }

    protected String getAuthenticationClassReference(HttpServletRequest request, HttpServletResponse response) {
        List queryParams;
        Optional<NameValuePair> parameter;
        String serviceParam;
        JEEContext context = new JEEContext(request, response);
        String acr = this.oauthRequestParameterResolver.resolveRequestParameter((WebContext)context, "acr_values").orElse("");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)acr) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(serviceParam = request.getParameter("service"))) && (parameter = (queryParams = (List)Unchecked.supplier(() -> new URIBuilder(UriComponentsBuilder.fromUriString((String)serviceParam).toUriString()).getQueryParams()).get()).stream().filter(p -> p.getName().equals("acr_values")).findFirst()).isPresent()) {
            return EncodingUtils.urlDecode((String)parameter.get().getValue());
        }
        return EncodingUtils.urlDecode((String)acr);
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public MultifactorAuthenticationProviderResolver getMultifactorAuthenticationProviderResolver() {
        return this.multifactorAuthenticationProviderResolver;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public OAuth20RequestParameterResolver getOauthRequestParameterResolver() {
        return this.oauthRequestParameterResolver;
    }

    @Generated
    public FactoryBean<OidcServerDiscoverySettings> getDiscoverySettingsFactory() {
        return this.discoverySettingsFactory;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public OidcMultifactorAuthenticationTrigger(CasConfigurationProperties casProperties, MultifactorAuthenticationProviderResolver multifactorAuthenticationProviderResolver, ApplicationContext applicationContext, OAuth20RequestParameterResolver oauthRequestParameterResolver, FactoryBean<OidcServerDiscoverySettings> discoverySettingsFactory) {
        this.casProperties = casProperties;
        this.multifactorAuthenticationProviderResolver = multifactorAuthenticationProviderResolver;
        this.applicationContext = applicationContext;
        this.oauthRequestParameterResolver = oauthRequestParameterResolver;
        this.discoverySettingsFactory = discoverySettingsFactory;
    }
}

