/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.OIDCC4UIProvider;
import org.apache.syncope.core.persistence.api.entity.OIDCC4UIUserTemplate;
import org.apache.syncope.core.persistence.api.validation.OIDCC4UIProviderCheck;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.persistence.jpa.entity.JPAOIDCC4UIUserTemplate;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.springframework.util.CollectionUtils;

@Entity
@Table(name="OIDCProvider")
@Cacheable
@OIDCC4UIProviderCheck
public class JPAOIDCC4UIProvider
extends AbstractGeneratedKeyEntity
implements OIDCC4UIProvider,
PersistenceCapable {
    public static final String TABLE = "OIDCProvider";
    private static final long serialVersionUID = 1423093003585826403L;
    @Column(unique=true, nullable=false)
    private String name;
    @Column(unique=true, nullable=false)
    private String clientID;
    @Column(unique=true, nullable=false)
    private String clientSecret;
    @Column(nullable=false)
    private String authorizationEndpoint;
    @Column(nullable=false)
    private String tokenEndpoint;
    @Column(nullable=false)
    private String jwksUri;
    @Column(nullable=false)
    private String issuer;
    @Column(nullable=true)
    private String userinfoEndpoint;
    @Column(nullable=true)
    private String endSessionEndpoint;
    private String scopes;
    @Column(nullable=false)
    private boolean hasDiscovery;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="op")
    private JPAOIDCC4UIUserTemplate userTemplate;
    @Lob
    private String items;
    @Transient
    private final List<Item> itemList = new ArrayList<Item>();
    @NotNull
    private Boolean createUnmatching = false;
    @NotNull
    private Boolean selfRegUnmatching = false;
    @NotNull
    private Boolean updateMatching = false;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="OIDCProviderAction", joinColumns={@JoinColumn(name="op_id")}, inverseJoinColumns={@JoinColumn(name="implementation_id")})
    private List<JPAImplementation> actions = new ArrayList<JPAImplementation>();
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public String getName() {
        return JPAOIDCC4UIProvider.pcGetname(this);
    }

    public void setName(String name) {
        JPAOIDCC4UIProvider.pcSetname(this, name);
    }

    public String getClientID() {
        return JPAOIDCC4UIProvider.pcGetclientID(this);
    }

    public void setClientID(String clientID) {
        JPAOIDCC4UIProvider.pcSetclientID(this, clientID);
    }

    public String getClientSecret() {
        return JPAOIDCC4UIProvider.pcGetclientSecret(this);
    }

    public void setClientSecret(String clientSecret) {
        JPAOIDCC4UIProvider.pcSetclientSecret(this, clientSecret);
    }

    public String getAuthorizationEndpoint() {
        return JPAOIDCC4UIProvider.pcGetauthorizationEndpoint(this);
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        JPAOIDCC4UIProvider.pcSetauthorizationEndpoint(this, authorizationEndpoint);
    }

    public String getTokenEndpoint() {
        return JPAOIDCC4UIProvider.pcGettokenEndpoint(this);
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        JPAOIDCC4UIProvider.pcSettokenEndpoint(this, tokenEndpoint);
    }

    public String getJwksUri() {
        return JPAOIDCC4UIProvider.pcGetjwksUri(this);
    }

    public void setJwksUri(String jwksUri) {
        JPAOIDCC4UIProvider.pcSetjwksUri(this, jwksUri);
    }

    public String getIssuer() {
        return JPAOIDCC4UIProvider.pcGetissuer(this);
    }

    public void setIssuer(String issuer) {
        JPAOIDCC4UIProvider.pcSetissuer(this, issuer);
    }

    public String getUserinfoEndpoint() {
        return JPAOIDCC4UIProvider.pcGetuserinfoEndpoint(this);
    }

    public void setUserinfoEndpoint(String userinfoEndpoint) {
        JPAOIDCC4UIProvider.pcSetuserinfoEndpoint(this, userinfoEndpoint);
    }

    public String getEndSessionEndpoint() {
        return JPAOIDCC4UIProvider.pcGetendSessionEndpoint(this);
    }

    public void setEndSessionEndpoint(String endSessionEndpoint) {
        JPAOIDCC4UIProvider.pcSetendSessionEndpoint(this, endSessionEndpoint);
    }

    public List<String> getScopes() {
        return Optional.ofNullable(JPAOIDCC4UIProvider.pcGetscopes(this)).map(s -> Stream.of(s.split(" ")).toList()).orElseGet(List::of);
    }

    public void setScopes(List<String> scopes) {
        JPAOIDCC4UIProvider.pcSetscopes(this, CollectionUtils.isEmpty(scopes) ? "" : String.join((CharSequence)" ", scopes));
    }

    public boolean getHasDiscovery() {
        return JPAOIDCC4UIProvider.pcGethasDiscovery(this);
    }

    public void setHasDiscovery(boolean hasDiscovery) {
        JPAOIDCC4UIProvider.pcSethasDiscovery(this, hasDiscovery);
    }

    public boolean isCreateUnmatching() {
        return JPAOIDCC4UIProvider.pcGetcreateUnmatching(this);
    }

    public void setCreateUnmatching(boolean createUnmatching) {
        JPAOIDCC4UIProvider.pcSetcreateUnmatching(this, createUnmatching);
    }

    public boolean isSelfRegUnmatching() {
        return JPAOIDCC4UIProvider.pcGetselfRegUnmatching(this);
    }

    public void setSelfRegUnmatching(boolean selfRegUnmatching) {
        JPAOIDCC4UIProvider.pcSetselfRegUnmatching(this, selfRegUnmatching);
    }

    public boolean isUpdateMatching() {
        return JPAOIDCC4UIProvider.pcGetupdateMatching(this);
    }

    public void setUpdateMatching(boolean updateMatching) {
        JPAOIDCC4UIProvider.pcSetupdateMatching(this, updateMatching);
    }

    public OIDCC4UIUserTemplate getUserTemplate() {
        return JPAOIDCC4UIProvider.pcGetuserTemplate(this);
    }

    public void setUserTemplate(OIDCC4UIUserTemplate userTemplate) {
        this.checkType(userTemplate, JPAOIDCC4UIUserTemplate.class);
        JPAOIDCC4UIProvider.pcSetuserTemplate(this, (JPAOIDCC4UIUserTemplate)userTemplate);
    }

    public List<Item> getItems() {
        return this.itemList;
    }

    public Optional<Item> getConnObjectKeyItem() {
        return this.getItems().stream().filter(Item::isConnObjectKey).findFirst();
    }

    public void setConnObjectKeyItem(Item item) {
        item.setConnObjectKey(true);
        this.getItems().add(item);
    }

    public boolean add(Implementation action) {
        this.checkType(action, JPAImplementation.class);
        this.checkImplementationType(action, "OP_ACTIONS");
        return JPAOIDCC4UIProvider.pcGetactions(this).contains((JPAImplementation)action) || JPAOIDCC4UIProvider.pcGetactions(this).add((JPAImplementation)action);
    }

    public List<? extends Implementation> getActions() {
        return JPAOIDCC4UIProvider.pcGetactions(this);
    }

    protected void json2list(boolean clearFirst) {
        if (clearFirst) {
            this.getItems().clear();
        }
        if (JPAOIDCC4UIProvider.pcGetitems(this) != null) {
            this.getItems().addAll((Collection)POJOHelper.deserialize((String)JPAOIDCC4UIProvider.pcGetitems(this), (TypeReference)new TypeReference<List<Item>>(this){}));
        }
    }

    @PostLoad
    public void postLoad() {
        this.json2list(false);
    }

    @PostPersist
    @PostUpdate
    public void postSave() {
        this.json2list(true);
    }

    @PrePersist
    @PreUpdate
    public void list2json() {
        JPAOIDCC4UIProvider.pcSetitems(this, POJOHelper.serialize(this.getItems()));
    }

    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcPCSuperclass = AbstractGeneratedKeyEntity.class;
        pcFieldNames = new String[]{"actions", "authorizationEndpoint", "clientID", "clientSecret", "createUnmatching", "endSessionEndpoint", "hasDiscovery", "issuer", "items", "jwksUri", "name", "scopes", "selfRegUnmatching", "tokenEndpoint", "updateMatching", "userTemplate", "userinfoEndpoint"};
        pcFieldTypes = new Class[]{List.class, String.class, String.class, String.class, Boolean.class, String.class, Boolean.TYPE, String.class, String.class, String.class, String.class, String.class, Boolean.class, String.class, Boolean.class, JPAOIDCC4UIUserTemplate.class, String.class};
        pcFieldFlags = new byte[]{10, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        PCRegistry.register(JPAOIDCC4UIProvider.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAOIDCC4UIProvider", (PersistenceCapable)new JPAOIDCC4UIProvider());
    }

    protected void pcClearFields() {
        super.pcClearFields();
        this.actions = null;
        this.authorizationEndpoint = null;
        this.clientID = null;
        this.clientSecret = null;
        this.createUnmatching = null;
        this.endSessionEndpoint = null;
        this.hasDiscovery = false;
        this.issuer = null;
        this.items = null;
        this.jwksUri = null;
        this.name = null;
        this.scopes = null;
        this.selfRegUnmatching = null;
        this.tokenEndpoint = null;
        this.updateMatching = null;
        this.userTemplate = null;
        this.userinfoEndpoint = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAOIDCC4UIProvider jPAOIDCC4UIProvider = new JPAOIDCC4UIProvider();
        if (bl) {
            jPAOIDCC4UIProvider.pcClearFields();
        }
        jPAOIDCC4UIProvider.pcStateManager = stateManager;
        jPAOIDCC4UIProvider.pcCopyKeyFieldsFromObjectId(object);
        return jPAOIDCC4UIProvider;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAOIDCC4UIProvider jPAOIDCC4UIProvider = new JPAOIDCC4UIProvider();
        if (bl) {
            jPAOIDCC4UIProvider.pcClearFields();
        }
        jPAOIDCC4UIProvider.pcStateManager = stateManager;
        return jPAOIDCC4UIProvider;
    }

    protected static int pcGetManagedFieldCount() {
        return 17 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.actions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.authorizationEndpoint = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.clientID = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.clientSecret = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.createUnmatching = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.endSessionEndpoint = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.hasDiscovery = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.issuer = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.items = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.jwksUri = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.scopes = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.selfRegUnmatching = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.tokenEndpoint = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.updateMatching = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.userTemplate = (JPAOIDCC4UIUserTemplate)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 16: {
                this.userinfoEndpoint = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.actions);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.authorizationEndpoint);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.clientID);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.clientSecret);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createUnmatching);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.endSessionEndpoint);
                return;
            }
            case 6: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.hasDiscovery);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.issuer);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.items);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.jwksUri);
                return;
            }
            case 10: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 11: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.scopes);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.selfRegUnmatching);
                return;
            }
            case 13: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.tokenEndpoint);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.updateMatching);
                return;
            }
            case 15: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.userTemplate);
                return;
            }
            case 16: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.userinfoEndpoint);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField((AbstractGeneratedKeyEntity)jPAOIDCC4UIProvider, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.actions = jPAOIDCC4UIProvider.actions;
                return;
            }
            case 1: {
                this.authorizationEndpoint = jPAOIDCC4UIProvider.authorizationEndpoint;
                return;
            }
            case 2: {
                this.clientID = jPAOIDCC4UIProvider.clientID;
                return;
            }
            case 3: {
                this.clientSecret = jPAOIDCC4UIProvider.clientSecret;
                return;
            }
            case 4: {
                this.createUnmatching = jPAOIDCC4UIProvider.createUnmatching;
                return;
            }
            case 5: {
                this.endSessionEndpoint = jPAOIDCC4UIProvider.endSessionEndpoint;
                return;
            }
            case 6: {
                this.hasDiscovery = jPAOIDCC4UIProvider.hasDiscovery;
                return;
            }
            case 7: {
                this.issuer = jPAOIDCC4UIProvider.issuer;
                return;
            }
            case 8: {
                this.items = jPAOIDCC4UIProvider.items;
                return;
            }
            case 9: {
                this.jwksUri = jPAOIDCC4UIProvider.jwksUri;
                return;
            }
            case 10: {
                this.name = jPAOIDCC4UIProvider.name;
                return;
            }
            case 11: {
                this.scopes = jPAOIDCC4UIProvider.scopes;
                return;
            }
            case 12: {
                this.selfRegUnmatching = jPAOIDCC4UIProvider.selfRegUnmatching;
                return;
            }
            case 13: {
                this.tokenEndpoint = jPAOIDCC4UIProvider.tokenEndpoint;
                return;
            }
            case 14: {
                this.updateMatching = jPAOIDCC4UIProvider.updateMatching;
                return;
            }
            case 15: {
                this.userTemplate = jPAOIDCC4UIProvider.userTemplate;
                return;
            }
            case 16: {
                this.userinfoEndpoint = jPAOIDCC4UIProvider.userinfoEndpoint;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JPAOIDCC4UIProvider jPAOIDCC4UIProvider = (JPAOIDCC4UIProvider)((Object)object);
        if (jPAOIDCC4UIProvider.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAOIDCC4UIProvider, nArray[i]);
        }
    }

    public Class pcGetIDOwningClass() {
        return JPAOIDCC4UIProvider.class;
    }

    private static final List pcGetactions(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.actions;
        }
        int n = pcInheritedFieldCount + 0;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.actions;
    }

    private static final void pcSetactions(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, List list) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.actions = list;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingObjectField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 0, jPAOIDCC4UIProvider.actions, (Object)list, 0);
    }

    private static final String pcGetauthorizationEndpoint(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.authorizationEndpoint;
        }
        int n = pcInheritedFieldCount + 1;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.authorizationEndpoint;
    }

    private static final void pcSetauthorizationEndpoint(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, String string) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.authorizationEndpoint = string;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingStringField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 1, jPAOIDCC4UIProvider.authorizationEndpoint, string, 0);
    }

    private static final String pcGetclientID(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.clientID;
        }
        int n = pcInheritedFieldCount + 2;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.clientID;
    }

    private static final void pcSetclientID(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, String string) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.clientID = string;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingStringField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 2, jPAOIDCC4UIProvider.clientID, string, 0);
    }

    private static final String pcGetclientSecret(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.clientSecret;
        }
        int n = pcInheritedFieldCount + 3;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.clientSecret;
    }

    private static final void pcSetclientSecret(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, String string) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.clientSecret = string;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingStringField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 3, jPAOIDCC4UIProvider.clientSecret, string, 0);
    }

    private static final Boolean pcGetcreateUnmatching(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.createUnmatching;
        }
        int n = pcInheritedFieldCount + 4;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.createUnmatching;
    }

    private static final void pcSetcreateUnmatching(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, Boolean bl) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.createUnmatching = bl;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingObjectField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 4, (Object)jPAOIDCC4UIProvider.createUnmatching, (Object)bl, 0);
    }

    private static final String pcGetendSessionEndpoint(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.endSessionEndpoint;
        }
        int n = pcInheritedFieldCount + 5;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.endSessionEndpoint;
    }

    private static final void pcSetendSessionEndpoint(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, String string) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.endSessionEndpoint = string;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingStringField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 5, jPAOIDCC4UIProvider.endSessionEndpoint, string, 0);
    }

    private static final boolean pcGethasDiscovery(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.hasDiscovery;
        }
        int n = pcInheritedFieldCount + 6;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.hasDiscovery;
    }

    private static final void pcSethasDiscovery(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, boolean bl) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.hasDiscovery = bl;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingBooleanField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 6, jPAOIDCC4UIProvider.hasDiscovery, bl, 0);
    }

    private static final String pcGetissuer(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.issuer;
        }
        int n = pcInheritedFieldCount + 7;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.issuer;
    }

    private static final void pcSetissuer(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, String string) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.issuer = string;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingStringField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 7, jPAOIDCC4UIProvider.issuer, string, 0);
    }

    private static final String pcGetitems(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.items;
        }
        int n = pcInheritedFieldCount + 8;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.items;
    }

    private static final void pcSetitems(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, String string) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.items = string;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingStringField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 8, jPAOIDCC4UIProvider.items, string, 0);
    }

    private static final String pcGetjwksUri(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.jwksUri;
        }
        int n = pcInheritedFieldCount + 9;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.jwksUri;
    }

    private static final void pcSetjwksUri(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, String string) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.jwksUri = string;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingStringField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 9, jPAOIDCC4UIProvider.jwksUri, string, 0);
    }

    private static final String pcGetname(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.name;
        }
        int n = pcInheritedFieldCount + 10;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.name;
    }

    private static final void pcSetname(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, String string) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.name = string;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingStringField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 10, jPAOIDCC4UIProvider.name, string, 0);
    }

    private static final String pcGetscopes(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.scopes;
        }
        int n = pcInheritedFieldCount + 11;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.scopes;
    }

    private static final void pcSetscopes(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, String string) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.scopes = string;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingStringField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 11, jPAOIDCC4UIProvider.scopes, string, 0);
    }

    private static final Boolean pcGetselfRegUnmatching(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.selfRegUnmatching;
        }
        int n = pcInheritedFieldCount + 12;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.selfRegUnmatching;
    }

    private static final void pcSetselfRegUnmatching(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, Boolean bl) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.selfRegUnmatching = bl;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingObjectField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 12, (Object)jPAOIDCC4UIProvider.selfRegUnmatching, (Object)bl, 0);
    }

    private static final String pcGettokenEndpoint(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.tokenEndpoint;
        }
        int n = pcInheritedFieldCount + 13;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.tokenEndpoint;
    }

    private static final void pcSettokenEndpoint(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, String string) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.tokenEndpoint = string;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingStringField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 13, jPAOIDCC4UIProvider.tokenEndpoint, string, 0);
    }

    private static final Boolean pcGetupdateMatching(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.updateMatching;
        }
        int n = pcInheritedFieldCount + 14;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.updateMatching;
    }

    private static final void pcSetupdateMatching(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, Boolean bl) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.updateMatching = bl;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingObjectField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 14, (Object)jPAOIDCC4UIProvider.updateMatching, (Object)bl, 0);
    }

    private static final JPAOIDCC4UIUserTemplate pcGetuserTemplate(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.userTemplate;
        }
        int n = pcInheritedFieldCount + 15;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.userTemplate;
    }

    private static final void pcSetuserTemplate(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, JPAOIDCC4UIUserTemplate jPAOIDCC4UIUserTemplate) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.userTemplate = jPAOIDCC4UIUserTemplate;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingObjectField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 15, (Object)jPAOIDCC4UIProvider.userTemplate, (Object)jPAOIDCC4UIUserTemplate, 0);
    }

    private static final String pcGetuserinfoEndpoint(JPAOIDCC4UIProvider jPAOIDCC4UIProvider) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            return jPAOIDCC4UIProvider.userinfoEndpoint;
        }
        int n = pcInheritedFieldCount + 16;
        jPAOIDCC4UIProvider.pcStateManager.accessingField(n);
        return jPAOIDCC4UIProvider.userinfoEndpoint;
    }

    private static final void pcSetuserinfoEndpoint(JPAOIDCC4UIProvider jPAOIDCC4UIProvider, String string) {
        if (jPAOIDCC4UIProvider.pcStateManager == null) {
            jPAOIDCC4UIProvider.userinfoEndpoint = string;
            return;
        }
        jPAOIDCC4UIProvider.pcStateManager.settingStringField((PersistenceCapable)jPAOIDCC4UIProvider, pcInheritedFieldCount + 16, jPAOIDCC4UIProvider.userinfoEndpoint, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

