/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.task.LiveSyncTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class LiveSyncTaskSaver {
    protected final ExternalResourceDAO resourceDAO;
    protected final TaskDAO taskDAO;
    protected final TaskExecDAO taskExecDAO;
    protected final TaskUtilsFactory taskUtilsFactory;
    protected final NotificationManager notificationManager;
    protected final AuditManager auditManager;

    public LiveSyncTaskSaver(ExternalResourceDAO resourceDAO, TaskDAO taskDAO, TaskExecDAO taskExecDAO, TaskUtilsFactory taskUtilsFactory, NotificationManager notificationManager, AuditManager auditManager) {
        this.resourceDAO = resourceDAO;
        this.taskDAO = taskDAO;
        this.taskExecDAO = taskExecDAO;
        this.taskUtilsFactory = taskUtilsFactory;
        this.notificationManager = notificationManager;
        this.auditManager = auditManager;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void addAttr(AnyUtils anyUtils, PlainAttrValidationManager validator, String key, PlainSchema schema, String value) {
        anyUtils.addAttr(validator, key, schema, value);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void save(String taskKey, TaskExec<SchedTask> execution, String message, String status, OpEvent.Outcome result, Function<TaskExec<SchedTask>, Boolean> hasToBeRegistered) throws JobExecutionException {
        LiveSyncTask task = (LiveSyncTask)this.taskDAO.findById(TaskType.LIVE_SYNC, taskKey).orElseThrow(() -> new JobExecutionException("Not found: " + String.valueOf(TaskType.LIVE_SYNC) + " Task " + taskKey));
        execution.setTask((Task)task);
        execution.setMessage(message);
        execution.setStatus(status);
        execution.setEnd(OffsetDateTime.now());
        if (hasToBeRegistered.apply(execution).booleanValue()) {
            this.taskExecDAO.saveAndAdd(TaskType.LIVE_SYNC, task.getKey(), execution);
        }
        task = (LiveSyncTask)this.taskDAO.save((Entity)task);
        this.notificationManager.createTasks(execution.getExecutor(), OpEvent.CategoryType.TASK, this.getClass().getSimpleName(), null, this.getClass().getSimpleName(), result, (Object)task, execution, new Object[0]);
        this.auditManager.audit(AuthContextUtils.getDomain(), execution.getExecutor(), OpEvent.CategoryType.TASK, task.getClass().getSimpleName(), null, this.getClass().getSimpleName(), result, (Object)task, execution, new Object[0]);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void save(String resourceKey, Map<String, SyncToken> latestSyncTokens) throws JobExecutionException {
        ExternalResource resource = (ExternalResource)this.resourceDAO.findById(resourceKey).orElseThrow(() -> new JobExecutionException("Not found: ExternalResource " + resourceKey));
        latestSyncTokens.forEach((objectClass, syncToken) -> {
            resource.getProvisionByObjectClass(objectClass).ifPresent(p -> p.setSyncToken(ConnObjectUtils.toString(syncToken)));
            Optional.ofNullable(resource.getOrgUnit()).filter(ou -> objectClass.equals(ou.getObjectClass())).ifPresent(ou -> ou.setSyncToken(ConnObjectUtils.toString(syncToken)));
        });
        this.resourceDAO.save((Entity)resource);
    }
}

