/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.impl.token;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.data.annotation.Id;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class PasswordlessAuthenticationToken
implements Serializable {
    private static final long serialVersionUID = 3810773120720229099L;
    @Id
    @JsonProperty
    private String id;
    private String username;
    private String token;
    private ZonedDateTime expirationDate;
    @JsonProperty(value="properties")
    private Map<String, String> properties;

    @JsonIgnore
    public boolean isExpired() {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        return now.isAfter(this.getExpirationDate()) || now.isEqual(this.getExpirationDate());
    }

    @JsonIgnore
    @CanIgnoreReturnValue
    public PasswordlessAuthenticationToken property(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    @Generated
    private static Map<String, String> $default$properties() {
        return new HashMap<String, String>();
    }

    @Generated
    protected PasswordlessAuthenticationToken(PasswordlessAuthenticationTokenBuilder<?, ?> b) {
        this.id = b.id;
        this.username = b.username;
        this.token = b.token;
        this.expirationDate = b.expirationDate;
        this.properties = b.properties$set ? b.properties$value : PasswordlessAuthenticationToken.$default$properties();
    }

    @Generated
    public static PasswordlessAuthenticationTokenBuilder<?, ?> builder() {
        return new PasswordlessAuthenticationTokenBuilderImpl();
    }

    @Generated
    public String toString() {
        return "PasswordlessAuthenticationToken(id=" + this.id + ", username=" + this.username + ", token=" + this.token + ", expirationDate=" + String.valueOf(this.expirationDate) + ", properties=" + String.valueOf(this.properties) + ")";
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public ZonedDateTime getExpirationDate() {
        return this.expirationDate;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setExpirationDate(ZonedDateTime expirationDate) {
        this.expirationDate = expirationDate;
    }

    @JsonProperty(value="properties")
    @Generated
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Generated
    public PasswordlessAuthenticationToken(String id, String username, String token, ZonedDateTime expirationDate, Map<String, String> properties) {
        this.id = id;
        this.username = username;
        this.token = token;
        this.expirationDate = expirationDate;
        this.properties = properties;
    }

    @Generated
    public PasswordlessAuthenticationToken() {
        this.properties = PasswordlessAuthenticationToken.$default$properties();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PasswordlessAuthenticationToken)) {
            return false;
        }
        PasswordlessAuthenticationToken other = (PasswordlessAuthenticationToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$username = this.username;
        String other$username = other.username;
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$token = this.token;
        String other$token = other.token;
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        ZonedDateTime this$expirationDate = this.expirationDate;
        ZonedDateTime other$expirationDate = other.expirationDate;
        if (this$expirationDate == null ? other$expirationDate != null : !((Object)this$expirationDate).equals(other$expirationDate)) {
            return false;
        }
        Map<String, String> this$properties = this.properties;
        Map<String, String> other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PasswordlessAuthenticationToken;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $username = this.username;
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $token = this.token;
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        ZonedDateTime $expirationDate = this.expirationDate;
        result = result * 59 + ($expirationDate == null ? 43 : ((Object)$expirationDate).hashCode());
        Map<String, String> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    @Generated
    public PasswordlessAuthenticationToken withId(String id) {
        return this.id == id ? this : new PasswordlessAuthenticationToken(id, this.username, this.token, this.expirationDate, this.properties);
    }

    @Generated
    public PasswordlessAuthenticationToken withUsername(String username) {
        return this.username == username ? this : new PasswordlessAuthenticationToken(this.id, username, this.token, this.expirationDate, this.properties);
    }

    @Generated
    public PasswordlessAuthenticationToken withToken(String token) {
        return this.token == token ? this : new PasswordlessAuthenticationToken(this.id, this.username, token, this.expirationDate, this.properties);
    }

    @Generated
    public PasswordlessAuthenticationToken withExpirationDate(ZonedDateTime expirationDate) {
        return this.expirationDate == expirationDate ? this : new PasswordlessAuthenticationToken(this.id, this.username, this.token, expirationDate, this.properties);
    }

    @Generated
    public PasswordlessAuthenticationToken withProperties(Map<String, String> properties) {
        return this.properties == properties ? this : new PasswordlessAuthenticationToken(this.id, this.username, this.token, this.expirationDate, properties);
    }

    @Generated
    public static abstract class PasswordlessAuthenticationTokenBuilder<C extends PasswordlessAuthenticationToken, B extends PasswordlessAuthenticationTokenBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String username;
        @Generated
        private String token;
        @Generated
        private ZonedDateTime expirationDate;
        @Generated
        private boolean properties$set;
        @Generated
        private Map<String, String> properties$value;

        @JsonProperty
        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B username(String username) {
            this.username = username;
            return this.self();
        }

        @Generated
        public B token(String token) {
            this.token = token;
            return this.self();
        }

        @Generated
        public B expirationDate(ZonedDateTime expirationDate) {
            this.expirationDate = expirationDate;
            return this.self();
        }

        @JsonProperty(value="properties")
        @Generated
        public B properties(Map<String, String> properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "PasswordlessAuthenticationToken.PasswordlessAuthenticationTokenBuilder(id=" + this.id + ", username=" + this.username + ", token=" + this.token + ", expirationDate=" + String.valueOf(this.expirationDate) + ", properties$value=" + String.valueOf(this.properties$value) + ")";
        }
    }

    @Generated
    private static final class PasswordlessAuthenticationTokenBuilderImpl
    extends PasswordlessAuthenticationTokenBuilder<PasswordlessAuthenticationToken, PasswordlessAuthenticationTokenBuilderImpl> {
        @Generated
        private PasswordlessAuthenticationTokenBuilderImpl() {
        }

        @Override
        @Generated
        protected PasswordlessAuthenticationTokenBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PasswordlessAuthenticationToken build() {
            return new PasswordlessAuthenticationToken(this);
        }
    }
}

