/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.util.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.matching.matcher.Matcher;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.security.SecurityEndpoint;

public class SecurityEndpointBuilder {
    private static final AtomicInteger internalNumber = new AtomicInteger(1);

    /*
     * WARNING - void declaration
     */
    public static void buildConfig(SecurityEndpoint endpoint, Config config, Object ... parameters) {
        void var9_12;
        String clients = "";
        String authorizers = "";
        String matchers = "";
        ArrayList<Object> paramList = new ArrayList<Object>();
        Object[] objectArray = parameters;
        int n = objectArray.length;
        boolean bl = false;
        while (var9_12 < n) {
            Object parameter = objectArray[var9_12];
            if (parameter instanceof Collection) {
                ((Collection)parameter).forEach(element -> paramList.add(element));
            } else if (parameter instanceof Object[]) {
                Arrays.stream((Object[])parameter).forEach(element -> paramList.add(element));
            } else {
                paramList.add(parameter);
            }
            ++var9_12;
        }
        int numString = 0;
        for (Object e : paramList) {
            String internalName;
            if (e instanceof String) {
                if (numString == 0) {
                    clients = (String)e;
                } else if (numString == 1) {
                    authorizers = (String)e;
                } else if (numString == 2) {
                    matchers = (String)e;
                } else {
                    throw new TechnicalException("Too many strings used in constructor");
                }
                ++numString;
                continue;
            }
            if (e instanceof Client) {
                clients = SecurityEndpointBuilder.addElement(clients, ((Client)e).getName());
                continue;
            }
            if (e instanceof Authorizer) {
                internalName = "$int_authorizer" + internalNumber.getAndIncrement();
                config.addAuthorizer(internalName, (Authorizer)e);
                authorizers = SecurityEndpointBuilder.addElement(authorizers, internalName);
                continue;
            }
            if (e instanceof Matcher) {
                internalName = "$int_matcher" + internalNumber.getAndIncrement();
                config.addMatcher(internalName, (Matcher)e);
                matchers = SecurityEndpointBuilder.addElement(matchers, internalName);
                continue;
            }
            if (e instanceof HttpActionAdapter) {
                endpoint.setHttpActionAdapter((HttpActionAdapter)e);
                continue;
            }
            if (e instanceof SecurityLogic) {
                endpoint.setSecurityLogic((SecurityLogic)e);
                continue;
            }
            throw new TechnicalException("Unsupported parameter type: " + e);
        }
        if (CommonHelper.isNotBlank(clients)) {
            endpoint.setClients(clients);
        }
        if (CommonHelper.isNotBlank(authorizers)) {
            endpoint.setAuthorizers(authorizers);
        }
        if (CommonHelper.isNotBlank(matchers)) {
            endpoint.setMatchers(matchers);
        }
    }

    private static String addElement(String elements, String element) {
        if (CommonHelper.isNotBlank(elements)) {
            return elements + "," + element;
        }
        return element;
    }
}

