/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command;

import java.io.OutputStream;
import java.util.SortedMap;
import java.util.TreeMap;
import liquibase.Scope;
import liquibase.command.CommandFailedException;
import liquibase.command.CommandResultDefinition;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.util.StringUtil;

public class CommandResultsBuilder {
    private final OutputStream outputStream;
    private final SortedMap<String, Object> resultValues = new TreeMap<String, Object>();
    private final CommandScope commandScope;

    CommandResultsBuilder(CommandScope commandScope, OutputStream outputStream) {
        this.outputStream = outputStream;
        this.commandScope = commandScope;
    }

    public CommandScope getCommandScope() {
        return this.commandScope;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public CommandResultsBuilder addResult(String key, Object value) {
        this.resultValues.put(key, value);
        return this;
    }

    public <T> CommandResultsBuilder addResult(CommandResultDefinition<T> definition, T value) {
        return this.addResult(definition.getName(), value);
    }

    public CommandFailedException commandFailed(String message, int exitCode) {
        return new CommandFailedException(this.build(), exitCode, message);
    }

    CommandResults build() {
        try {
            this.outputStream.flush();
        }
        catch (Exception e2) {
            Scope.getCurrentScope().getLog(this.getClass()).warning("Error flushing " + StringUtil.join(this.commandScope.getCommand().getName(), " ") + " output: " + e2.getMessage(), e2);
        }
        return new CommandResults(this.resultValues, this.commandScope);
    }
}

