/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

public class SyncopeJsonMapper
extends JsonMapper {
    private static final long serialVersionUID = -317191546835195103L;

    public SyncopeJsonMapper() {
        this.findAndRegisterModules();
        this.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    protected Object unwrapMap(Object value) {
        Map map;
        if (value instanceof Map && (map = (Map)value).size() == 1) {
            return map.values().iterator().next();
        }
        return value;
    }

    public void writeValue(JsonGenerator jgen, Object value) throws IOException {
        super.writeValue(jgen, this.unwrapMap(value));
    }

    public void writeValue(File resultFile, Object value) throws IOException {
        super.writeValue(resultFile, this.unwrapMap(value));
    }

    public void writeValue(OutputStream out, Object value) throws IOException {
        super.writeValue(out, this.unwrapMap(value));
    }

    public void writeValue(Writer writer, Object value) throws IOException {
        super.writeValue(writer, this.unwrapMap(value));
    }

    public byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
        return super.writeValueAsBytes(this.unwrapMap(value));
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        return super.writeValueAsString(this.unwrapMap(value));
    }
}

