/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.resource;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.inspektr.audit.spi.support.ParametersAsStringResourceResolver;

public class ProtocolSpecificationValidationAuditResourceResolver
extends ParametersAsStringResourceResolver {
    private final CasConfigurationProperties casProperties;

    protected String[] createResource(Object[] args) {
        String[] stringArray;
        LinkedHashMap results = new LinkedHashMap();
        Arrays.stream(args).forEach(arg -> {
            if (arg instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(arg);
                results.put("renew", StringUtils.defaultString((String)request.getParameter("renew"), (String)"false"));
                results.put("gateway", StringUtils.defaultString((String)request.getParameter("gateway"), (String)"false"));
            }
            if (arg instanceof Assertion) {
                Assertion assertion = (Assertion)Assertion.class.cast(arg);
                Authentication authn = assertion.getPrimaryAuthentication();
                results.put("principal", authn.getPrincipal().getId());
                results.put("service", DigestUtils.abbreviate((String)assertion.getService().getId()));
                if (this.casProperties.getAudit().getEngine().isIncludeValidationAssertion()) {
                    HashMap attributes = new HashMap(authn.getAttributes());
                    attributes.putAll(authn.getPrincipal().getAttributes());
                    results.put("attributes", attributes);
                }
            }
        });
        if (results.isEmpty()) {
            stringArray = ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.auditFormat.serialize(results);
        }
        return stringArray;
    }

    @Generated
    public ProtocolSpecificationValidationAuditResourceResolver(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }
}

