/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.DynamicPersistenceCapable;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.event.LifecycleEventManager;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.ClassUtil;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.lib.util.StringDistance;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.InMemoryRelatedFieldOrder;
import org.apache.openjpa.meta.InMemoryValueOrder;
import org.apache.openjpa.meta.InheritanceComparator;
import org.apache.openjpa.meta.InterfaceImplGenerator;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.meta.MetaDataModes;
import org.apache.openjpa.meta.NonPersistentMetaData;
import org.apache.openjpa.meta.Order;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.meta.ValueMetaDataImpl;
import org.apache.openjpa.meta.XMLClassMetaData;
import org.apache.openjpa.meta.XMLFieldMetaData;
import org.apache.openjpa.meta.XMLMetaData;
import org.apache.openjpa.util.ClassResolver;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.OpenJPAId;

public class MetaDataRepository
implements PCRegistry.RegisterClassListener,
Configurable,
Closeable,
MetaDataModes,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int VALIDATE_NONE = 0;
    public static final int VALIDATE_META = 1;
    public static final int VALIDATE_MAPPING = 2;
    public static final int VALIDATE_UNENHANCED = 4;
    public static final int VALIDATE_RUNTIME = 8;
    protected static final Class<?>[] EMPTY_CLASSES = new Class[0];
    protected static final NonPersistentMetaData[] EMPTY_NON_PERSISTENT = new NonPersistentMetaData[0];
    protected final ClassMetaData[] EMPTY_METAS;
    protected final FieldMetaData[] EMPTY_FIELDS;
    protected final Order[] EMPTY_ORDERS;
    private static final Localizer _loc = Localizer.forPackage(MetaDataRepository.class);
    private SequenceMetaData _sysSeq = null;
    private Map<Class<?>, ClassMetaData> _metas = new HashMap();
    private Map<String, ClassMetaData> _metaStringMap = new ConcurrentHashMap<String, ClassMetaData>();
    private Map<Class<?>, Class<?>> _oids = Collections.synchronizedMap(new HashMap());
    private Map<Class<?>, Collection<Class<?>>> _impls = Collections.synchronizedMap(new HashMap());
    private Map<Class<?>, Class<?>> _ifaces = Collections.synchronizedMap(new HashMap());
    private Map<String, QueryMetaData> _queries = new HashMap<String, QueryMetaData>();
    private Map<String, SequenceMetaData> _seqs = new HashMap<String, SequenceMetaData>();
    private Map<String, List<Class<?>>> _aliases = Collections.synchronizedMap(new HashMap());
    private Map<Class<?>, NonPersistentMetaData> _pawares = Collections.synchronizedMap(new HashMap());
    private Map<Class<?>, NonPersistentMetaData> _nonMapped = Collections.synchronizedMap(new HashMap());
    private Map<Class<?>, Class<?>> _metamodel = Collections.synchronizedMap(new HashMap());
    private Map<Class<?>, Collection<Class<?>>> _subs = Collections.synchronizedMap(new HashMap());
    protected final XMLMetaData[] EMPTY_XMLMETAS;
    private final Map<Class<?>, XMLMetaData> _xmlmetas = new HashMap();
    private transient OpenJPAConfiguration _conf = null;
    private transient Log _log = null;
    private transient InterfaceImplGenerator _implGen = null;
    private transient MetaDataFactory _factory = null;
    private int _resMode = 3;
    private int _sourceMode = 7;
    private int _validate = 5;
    private final Collection<Class<?>> _registered = new HashSet();
    private final List<ClassMetaData> _resolving = new ArrayList<ClassMetaData>();
    private final List<ClassMetaData> _mapping = new ArrayList<ClassMetaData>();
    private final List<RuntimeException> _errs = new LinkedList<RuntimeException>();
    private LifecycleEventManager.ListenerList _listeners = new LifecycleEventManager.ListenerList(3);
    private boolean _systemListenersActivated = false;
    protected boolean _preload = false;
    protected boolean _preloadComplete = false;
    protected boolean _locking = true;
    private static final String PRELOAD_STR = "Preload";
    private boolean _logEnhancementLevel = true;
    private boolean _filterRegisteredClasses = false;
    private Collection<Class<?>> _typesWithoutEnhancement;

    public MetaDataRepository() {
        this.EMPTY_METAS = this.newClassMetaDataArray(0);
        this.EMPTY_FIELDS = this.newFieldMetaDataArray(0);
        this.EMPTY_ORDERS = this.newOrderArray(0);
        this.EMPTY_XMLMETAS = this.newXMLClassMetaDataArray(0);
    }

    public OpenJPAConfiguration getConfiguration() {
        return this._conf;
    }

    public Log getLog() {
        return this._log;
    }

    public MetaDataFactory getMetaDataFactory() {
        return this._factory;
    }

    public void setMetaDataFactory(MetaDataFactory factory) {
        factory.setRepository(this);
        this._factory = factory;
    }

    public int getValidate() {
        return this._validate;
    }

    public void setValidate(int validate) {
        this._validate = validate;
    }

    public void setValidate(int validate, boolean on) {
        this._validate = validate == 0 ? validate : (on ? (this._validate |= validate) : (this._validate &= ~validate));
    }

    public int getResolve() {
        return this._resMode;
    }

    public void setResolve(int mode) {
        this._resMode = mode;
    }

    public void setResolve(int mode, boolean on) {
        this._resMode = mode == 0 ? mode : (on ? (this._resMode |= mode) : (this._resMode &= ~mode));
    }

    public int getSourceMode() {
        return this._sourceMode;
    }

    public void setSourceMode(int mode) {
        this._sourceMode = mode;
    }

    public void setSourceMode(int mode, boolean on) {
        this._sourceMode = mode == 0 ? mode : (on ? (this._sourceMode |= mode) : (this._sourceMode &= ~mode));
    }

    public boolean getPreload() {
        return this._preload;
    }

    public void setPreload(boolean l) {
        this._preload = l;
    }

    public synchronized void preload() {
        Set<String> classes;
        ClassLoader cl;
        if (!this._preload) {
            return;
        }
        if (this._preloadComplete) {
            return;
        }
        MultiClassLoader multi = (MultiClassLoader)AccessController.doPrivileged(J2DoPrivHelper.newMultiClassLoaderAction());
        multi.addClassLoader((ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()));
        multi.addClassLoader((ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(MetaDataRepository.class)));
        ClassResolver resolver = this._conf.getClassResolverInstance();
        if (resolver != null && (cl = resolver.getClassLoader(null, null)) != null) {
            multi.addClassLoader(cl);
        }
        if ((classes = this.getPersistentTypeNames(false, (ClassLoader)multi)) == null || classes.size() == 0) {
            throw new MetaDataException(_loc.get("repos-initializeEager-none"));
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("repos-initializeEager-found", classes));
        }
        ArrayList<Class> loaded = new ArrayList<Class>();
        for (String c : classes) {
            try {
                Class cls = (Class)AccessController.doPrivileged(J2DoPrivHelper.getForNameAction((String)c, (boolean)true, (ClassLoader)multi));
                loaded.add(cls);
                this._factory.load(cls, 31, (ClassLoader)multi);
            }
            catch (PrivilegedActionException pae) {
                throw new MetaDataException(_loc.get("repos-initializeEager-error"), (Throwable)pae);
            }
        }
        this.resolveAll((ClassLoader)multi);
        for (Class cls : loaded) {
            ClassMetaData cmd = this.getCachedMetaData(cls);
            if (cmd == null) continue;
            this.getXMLMetaData(cls);
            for (FieldMetaData fmd : cmd.getFields()) {
                this.getXMLMetaData(fmd.getDeclaredType());
            }
        }
        PCRegistry.addRegisterClassListener(this);
        this.processRegisteredClasses((ClassLoader)multi);
        this._locking = false;
        this._preloadComplete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMetaData getMetaData(Class<?> cls, ClassLoader envLoader, boolean mustExist) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this.getMetaDataInternal(cls, envLoader, mustExist);
            }
        }
        return this.getMetaDataInternal(cls, envLoader, mustExist);
    }

    private ClassMetaData getMetaDataInternal(Class<?> cls, ClassLoader envLoader, boolean mustExist) {
        ClassMetaData meta = this.getMetaDataInternal(cls, envLoader);
        if (meta == null) {
            if (cls != null && DynamicPersistenceCapable.class.isAssignableFrom(cls)) {
                cls = cls.getSuperclass();
            }
            if (cls != null && this._implGen != null && this._implGen.isImplType(cls)) {
                cls = this._implGen.toManagedInterface(cls);
            }
            meta = this.getMetaDataInternal(cls, envLoader);
        }
        if (meta == null && mustExist) {
            if (cls != null && !ImplHelper.isManagedType(this._conf, cls)) {
                throw new MetaDataException(_loc.get("no-meta-notpc", cls)).setFatal(false);
            }
            Set<String> pcNames = this.getPersistentTypeNames(false, envLoader);
            if (pcNames != null && pcNames.size() > 0) {
                throw new MetaDataException(_loc.get("no-meta-types", cls, pcNames));
            }
            throw new MetaDataException(_loc.get("no-meta", cls));
        }
        this.resolve(meta);
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMetaData getMetaData(String alias, ClassLoader envLoader, boolean mustExist) {
        if (alias == null && mustExist) {
            throw new MetaDataException(_loc.get("no-alias-meta", (Object)alias, this._aliases));
        }
        if (alias == null) {
            return null;
        }
        this.processRegisteredClasses(envLoader);
        List<Class<?>> classList = this._aliases.get(alias);
        Set<String> pcNames = this.getPersistentTypeNames(false, envLoader);
        Class<?> cls = null;
        for (int i = 0; classList != null && i < classList.size(); ++i) {
            Class<?> c = classList.get(i);
            try {
                Class<?> nc = Class.forName(c.getName(), false, envLoader);
                if (pcNames != null && pcNames.size() != 0 && !pcNames.contains(nc.getName())) continue;
                cls = nc;
                if (classList.contains(cls)) break;
                classList.add(cls);
                break;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (cls != null) {
            return this.getMetaData(cls, envLoader, mustExist);
        }
        if (this._aliases.containsKey(alias)) {
            if (mustExist) {
                this.throwNoRegisteredAlias(alias);
            }
            return null;
        }
        Map<String, List<Class<?>>> map = this._aliases;
        synchronized (map) {
            this._aliases.put(alias, null);
        }
        if (!mustExist) {
            return null;
        }
        return this.throwNoRegisteredAlias(alias);
    }

    private ClassMetaData throwNoRegisteredAlias(String alias) {
        String close = this.getClosestAliasName(alias);
        if (close != null) {
            throw new MetaDataException(_loc.get("no-alias-meta-hint", (Object)alias, this._aliases, (Object)close));
        }
        throw new MetaDataException(_loc.get("no-alias-meta", (Object)alias, this._aliases));
    }

    public String getClosestAliasName(String alias) {
        Collection<String> aliases = this.getAliasNames();
        return StringDistance.getClosestLevenshteinDistance((String)alias, aliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAliasNames() {
        if (this._locking) {
            Map<String, List<Class<?>>> map = this._aliases;
            synchronized (map) {
                return this.getAliasNamesInternal();
            }
        }
        return this.getAliasNamesInternal();
    }

    private Collection<String> getAliasNamesInternal() {
        HashSet<String> aliases = new HashSet<String>();
        for (Map.Entry<String, List<Class<?>>> e : this._aliases.entrySet()) {
            if (e.getValue() == null) continue;
            aliases.add(e.getKey());
        }
        return aliases;
    }

    private ClassMetaData getMetaDataInternal(Class<?> cls, ClassLoader envLoader) {
        Set<String> pcNames2;
        if (cls == null) {
            return null;
        }
        ClassMetaData meta = this._metas.get(cls);
        if (meta != null && ((meta.getSourceMode() & 1) != 0 || (this._sourceMode & 1) == 0)) {
            return meta;
        }
        if ((this._validate & 8) != 0 && (pcNames2 = this.getPersistentTypeNames(false, envLoader)) != null && !pcNames2.contains(cls.getName())) {
            return meta;
        }
        if (meta == null) {
            if (this._metas.containsKey(cls)) {
                return null;
            }
            if (cls.isPrimitive() || cls.getName().startsWith("java.") || cls == PersistenceCapable.class) {
                return null;
            }
            if ((this._validate & 8) != 0) {
                try {
                    Class.forName(cls.getName(), true, (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(cls)));
                }
                catch (Throwable pcNames2) {
                    // empty catch block
                }
            }
        }
        int mode = 0;
        if ((this._sourceMode & 1) != 0) {
            mode = this._sourceMode & 0xFFFFFFFD;
        } else if ((this._sourceMode & 2) == 0) {
            mode = this._sourceMode;
        }
        if (mode != 0) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("load-cls", cls, (Object)MetaDataRepository.toModeString(mode)));
            }
            this._factory.load(cls, mode, envLoader);
        }
        if (meta == null) {
            meta = this._metas.get(cls);
        }
        if (meta != null && ((meta.getSourceMode() & 1) != 0 || (this._sourceMode & 1) == 0)) {
            return meta;
        }
        if (meta != null) {
            this.removeMetaData(meta);
        }
        this._metas.put(cls, null);
        return null;
    }

    private static String toModeString(int mode) {
        StringBuilder buf = new StringBuilder(31);
        if ((mode & 1) != 0) {
            buf.append("[META]");
        }
        if ((mode & 4) != 0) {
            buf.append("[QUERY]");
        }
        if ((mode & 2) != 0) {
            buf.append("[MAPPING]");
        }
        if ((mode & 8) != 0) {
            buf.append("[MAPPING_INIT]");
        }
        return buf.toString();
    }

    protected void prepareMapping(ClassMetaData meta) {
        meta.defineSuperclassFields(false);
    }

    /*
     * WARNING - void declaration
     */
    private void resolve(ClassMetaData meta) {
        if (meta == null || this._resMode == 0 || (meta.getResolve() & 1) != 0) {
            return;
        }
        List<ClassMetaData> resolved = this.resolveMeta(meta);
        if (resolved == null) {
            return;
        }
        for (ClassMetaData classMetaData : resolved) {
            this.loadMapping(classMetaData);
        }
        for (ClassMetaData classMetaData : resolved) {
            this.preMapping(classMetaData);
        }
        boolean err = true;
        if ((this._resMode & 2) != 0) {
            for (ClassMetaData classMetaData : resolved) {
                err &= this.resolveMapping(classMetaData);
            }
        }
        if (err && !this._errs.isEmpty()) {
            void var4_12;
            if (this._errs.size() == 1 && this._errs.get(0) instanceof MetaDataException) {
                RuntimeException runtimeException = this._errs.get(0);
            } else {
                OpenJPAException openJPAException = new MetaDataException(_loc.get("resolve-errs")).setNestedThrowables(this._errs.toArray(new Exception[this._errs.size()]));
            }
            this._errs.clear();
            throw var4_12;
        }
    }

    private List<ClassMetaData> resolveMeta(ClassMetaData meta) {
        FieldMetaData[] fmds;
        if (meta.getPCSuperclass() == null) {
            ClassMetaData supMeta;
            Class<?> sup;
            for (sup = meta.getDescribedType().getSuperclass(); sup != null && sup != Object.class; sup = sup.getSuperclass()) {
                supMeta = this.getMetaData(sup, meta.getEnvClassLoader(), false);
                if (supMeta == null) continue;
                meta.setPCSuperclass(sup);
                meta.setPCSuperclassMetaData(supMeta);
                break;
            }
            if (meta.getDescribedType().isInterface()) {
                Class<?>[] sups;
                for (Class<?> aClass : sups = meta.getDescribedType().getInterfaces()) {
                    supMeta = this.getMetaData(aClass, meta.getEnvClassLoader(), false);
                    if (supMeta == null) continue;
                    meta.setPCSuperclass(sup);
                    meta.setPCSuperclassMetaData(supMeta);
                    break;
                }
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("assigned-sup", (Object)meta, meta.getPCSuperclass()));
            }
        }
        for (FieldMetaData fmd : fmds = meta.getDeclaredFields()) {
            if (!fmd.isPrimaryKey()) continue;
            this.getMetaData(fmd.getDeclaredType(), meta.getEnvClassLoader(), false);
        }
        return this.processBuffer(meta, this._resolving, 1);
    }

    private void loadMapping(ClassMetaData meta) {
        if ((meta.getResolve() & 2) != 0) {
            return;
        }
        if ((meta.getSourceMode() & 2) == 0 && (this._sourceMode & 2) != 0) {
            if (meta.isEmbeddedOnly()) {
                meta.setSourceMode(2, true);
            } else {
                int mode = this._sourceMode & 0xFFFFFFFE;
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)_loc.get("load-mapping", (Object)meta, (Object)MetaDataRepository.toModeString(mode)));
                }
                try {
                    this._factory.load(meta.getDescribedType(), mode, meta.getEnvClassLoader());
                }
                catch (RuntimeException re) {
                    this.removeMetaData(meta);
                    this._errs.add(re);
                }
            }
        }
    }

    private void preMapping(ClassMetaData meta) {
        if ((meta.getResolve() & 2) != 0) {
            return;
        }
        try {
            if ((this._resMode & 2) != 0) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)_loc.get("prep-mapping", (Object)meta));
                }
                this.prepareMapping(meta);
            } else {
                meta.defineSuperclassFields(false);
            }
        }
        catch (RuntimeException re) {
            this.removeMetaData(meta);
            this._errs.add(re);
        }
    }

    private boolean resolveMapping(ClassMetaData meta) {
        List<ClassMetaData> mapped = this.processBuffer(meta, this._mapping, 2);
        if (mapped == null) {
            return false;
        }
        if ((this._resMode & 8) != 0) {
            Iterator<ClassMetaData> iterator = mapped.iterator();
            while (iterator.hasNext()) {
                ClassMetaData classMetaData;
                meta = classMetaData = iterator.next();
                try {
                    meta.resolve(8);
                }
                catch (RuntimeException re) {
                    this.removeMetaData(meta);
                    this._errs.add(re);
                }
            }
        }
        return true;
    }

    private List<ClassMetaData> processBuffer(ClassMetaData meta, List<ClassMetaData> buffer, int mode) {
        for (ClassMetaData cmd : buffer) {
            if (!cmd.getDescribedType().equals(meta.getDescribedType())) continue;
            return null;
        }
        buffer.add(meta);
        if (buffer.size() != 1) {
            return null;
        }
        ArrayList<ClassMetaData> processed = new ArrayList<ClassMetaData>(5);
        while (!buffer.isEmpty()) {
            ClassMetaData buffered = buffer.get(0);
            try {
                buffered.resolve(mode);
                processed.add(buffered);
                buffer.remove(buffered);
            }
            catch (RuntimeException re) {
                this._errs.add(re);
                for (ClassMetaData cmd : buffer) {
                    this.removeMetaData(cmd);
                    if (cmd == buffered) continue;
                    this._errs.add(new MetaDataException(_loc.get("prev-errs", (Object)cmd, (Object)buffered)));
                }
                buffer.clear();
            }
        }
        return processed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMetaData[] getMetaDatas() {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this.getMetaDatasInternal();
            }
        }
        return this.getMetaDatasInternal();
    }

    private ClassMetaData[] getMetaDatasInternal() {
        Object[] metas;
        for (ClassMetaData classMetaData : metas = this._metas.values().toArray(new ClassMetaData[this._metas.size()])) {
            if (classMetaData == null) continue;
            this.getMetaData(classMetaData.getDescribedType(), classMetaData.getEnvClassLoader(), true);
        }
        ArrayList<ClassMetaData> resolved = new ArrayList<ClassMetaData>(this._metas.size());
        for (ClassMetaData meta : this._metas.values()) {
            if (meta == null) continue;
            resolved.add(meta);
        }
        metas = resolved.toArray(this.newClassMetaDataArray(resolved.size()));
        Arrays.sort(metas);
        return metas;
    }

    public ClassMetaData getCachedMetaData(Class<?> cls) {
        return this._metas.get(cls);
    }

    public ClassMetaData addMetaData(Class<?> cls) {
        return this.addMetaData(cls, AccessCode.UNKNOWN);
    }

    public ClassMetaData addMetaData(Class<?> cls, int access) {
        return this.addMetaData(cls, access, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMetaData addMetaData(Class<?> cls, int access, boolean ignoreTransient) {
        if (cls == null || cls.isPrimitive()) {
            return null;
        }
        ClassMetaData meta = this.newClassMetaData(cls);
        this._factory.getDefaults().populate(meta, access, ignoreTransient);
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this.metasPutInternal(cls, meta);
            }
        }
        return this.metasPutInternal(cls, meta);
    }

    private ClassMetaData metasPutInternal(Class<?> cls, ClassMetaData meta) {
        if (this._pawares.containsKey(cls)) {
            throw new MetaDataException(_loc.get("pc-and-aware", cls));
        }
        this._metas.put(cls, meta);
        return meta;
    }

    protected ClassMetaData newClassMetaData(Class<?> type) {
        return new ClassMetaData(type, this);
    }

    protected ClassMetaData[] newClassMetaDataArray(int length) {
        return new ClassMetaData[length];
    }

    protected FieldMetaData newFieldMetaData(String name, Class<?> type, ClassMetaData owner) {
        return new FieldMetaData(name, type, owner);
    }

    protected FieldMetaData[] newFieldMetaDataArray(int length) {
        return new FieldMetaData[length];
    }

    protected XMLMetaData[] newXMLClassMetaDataArray(int length) {
        return new XMLClassMetaData[length];
    }

    protected ClassMetaData newEmbeddedClassMetaData(ValueMetaData owner) {
        return new ClassMetaData(owner);
    }

    protected ValueMetaData newValueMetaData(FieldMetaData owner) {
        return new ValueMetaDataImpl(owner);
    }

    protected Order newOrder(FieldMetaData owner, String name, boolean asc) {
        ClassMetaData meta;
        if (name.startsWith("#element")) {
            name = name.substring("#element".length());
        }
        if (name.length() == 0) {
            return this.newValueOrder(owner, asc);
        }
        if (name.charAt(0) == '.') {
            name = name.substring(1);
        }
        if ((meta = owner.getElement().getTypeMetaData()) == null) {
            throw new MetaDataException(_loc.get("nonpc-field-orderable", (Object)owner, (Object)name));
        }
        FieldMetaData rel = this.getOrderByField(meta, name);
        if (rel == null) {
            throw new MetaDataException(_loc.get("bad-field-orderable", (Object)owner, (Object)name));
        }
        return this.newRelatedFieldOrder(owner, rel, asc);
    }

    public FieldMetaData getOrderByField(ClassMetaData meta, String orderBy) {
        FieldMetaData field = meta.getField(orderBy);
        if (field != null) {
            return field;
        }
        int dotIdx = orderBy.indexOf(".");
        if (dotIdx == -1) {
            return null;
        }
        String fieldName = orderBy.substring(0, dotIdx);
        FieldMetaData field1 = meta.getField(fieldName);
        if (field1 == null) {
            return null;
        }
        ClassMetaData meta1 = field1.getEmbeddedMetaData();
        if (meta1 == null) {
            return null;
        }
        String mappedBy1 = orderBy.substring(dotIdx + 1);
        return this.getOrderByField(meta1, mappedBy1);
    }

    protected Order newValueOrder(FieldMetaData owner, boolean asc) {
        return new InMemoryValueOrder(asc, this.getConfiguration());
    }

    protected Order newRelatedFieldOrder(FieldMetaData owner, FieldMetaData rel, boolean asc) {
        return new InMemoryRelatedFieldOrder(rel, asc, this.getConfiguration());
    }

    protected Order[] newOrderArray(int size) {
        return new Order[size];
    }

    public boolean removeMetaData(ClassMetaData meta) {
        if (meta == null) {
            return false;
        }
        return this.removeMetaData(meta.getDescribedType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMetaData(Class<?> cls) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this.removeMetaDataInternal(cls);
            }
        }
        return this.removeMetaDataInternal(cls);
    }

    private boolean removeMetaDataInternal(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        if (this._metas.remove(cls) != null) {
            Class<?> impl = this._ifaces.remove(cls);
            if (impl != null) {
                this._metas.remove(impl);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDeclaredInterfaceImpl(ClassMetaData meta, Class<?> iface) {
        if (this._locking) {
            Map<Class<?>, Collection<Class<?>>> map = this._impls;
            synchronized (map) {
                this.addDeclaredInterfaceImplInternal(meta, iface);
            }
        } else {
            this.addDeclaredInterfaceImplInternal(meta, iface);
        }
    }

    private void addDeclaredInterfaceImplInternal(ClassMetaData meta, Class<?> iface) {
        Collection<Class<?>> vals = this._impls.get(iface);
        if (vals != null) {
            for (ClassMetaData sup = meta.getPCSuperclassMetaData(); sup != null; sup = sup.getPCSuperclassMetaData()) {
                if (!vals.contains(sup.getDescribedType())) continue;
                return;
            }
        }
        this.addToCollection(this._impls, iface, meta.getDescribedType(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterfaceImpl(ClassMetaData meta, Class<?> impl) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                this.setInterfaceImplInternal(meta, impl);
            }
        } else {
            this.setInterfaceImplInternal(meta, impl);
        }
    }

    private void setInterfaceImplInternal(ClassMetaData meta, Class<?> impl) {
        if (!meta.isManagedInterface()) {
            throw new MetaDataException(_loc.get("not-managed-interface", (Object)meta, impl));
        }
        this._ifaces.put(meta.getDescribedType(), impl);
        this.addDeclaredInterfaceImpl(meta, meta.getDescribedType());
        for (ClassMetaData sup = meta.getPCSuperclassMetaData(); sup != null; sup = sup.getPCSuperclassMetaData()) {
            sup.clearSubclassCache();
            this.addToCollection(this._subs, sup.getDescribedType(), impl, true);
        }
    }

    InterfaceImplGenerator getImplGenerator() {
        return this._implGen;
    }

    public ClassMetaData getMetaData(Object oid, ClassLoader envLoader, boolean mustExist) {
        if (oid == null && mustExist) {
            throw new MetaDataException(_loc.get("no-oid-meta", oid, (Object)"?", (Object)this._oids.toString()));
        }
        if (oid == null) {
            return null;
        }
        if (oid instanceof OpenJPAId) {
            Class cls = ((OpenJPAId)oid).getType();
            return this.getMetaData(cls, envLoader, mustExist);
        }
        this.processRegisteredClasses(envLoader);
        Class<?> cls = this._oids.get(oid.getClass());
        if (cls != null) {
            return this.getMetaData(cls, envLoader, mustExist);
        }
        if (this._oids.containsKey(oid.getClass())) {
            if (mustExist) {
                throw new MetaDataException(_loc.get("no-oid-meta", oid, oid.getClass(), this._oids));
            }
            return null;
        }
        this.resolveIdentityClass(oid);
        if (this.processRegisteredClasses(envLoader).length > 0 && (cls = this._oids.get(oid.getClass())) != null) {
            return this.getMetaData(cls, envLoader, mustExist);
        }
        this._oids.put(oid.getClass(), null);
        if (!mustExist) {
            return null;
        }
        throw new MetaDataException(_loc.get("no-oid-meta", oid, oid.getClass(), this._oids)).setFailedObject(oid);
    }

    private void resolveIdentityClass(Object oid) {
        if (oid == null) {
            return;
        }
        Class<?> oidClass = oid.getClass();
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("resolve-identity", oidClass));
        }
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(oidClass));
        while (oidClass != null && oidClass != Object.class) {
            String className = oidClass.getName();
            for (int i = className.length(); i > 1 && className.charAt(i - 1) != '.'; --i) {
                try {
                    Class.forName(className.substring(0, i), true, cl);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            oidClass = oidClass.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMetaData[] getImplementorMetaDatas(Class<?> cls, ClassLoader envLoader, boolean mustExist) {
        if (cls == null && mustExist) {
            throw new MetaDataException(_loc.get("no-meta", cls));
        }
        if (cls == null) {
            return this.EMPTY_METAS;
        }
        this.loadRegisteredClassMetaData(envLoader);
        Collection<Class<?>> vals = this._impls.get(cls);
        ClassMetaData[] mapped = null;
        if (vals != null) {
            if (this._locking) {
                Collection<Class<?>> collection = vals;
                synchronized (collection) {
                    mapped = this.getImplementorMetaDatasInternal(vals, envLoader, mustExist);
                }
            } else {
                mapped = this.getImplementorMetaDatasInternal(vals, envLoader, mustExist);
            }
        }
        if (mapped == null && mustExist) {
            throw new MetaDataException(_loc.get("no-meta", cls));
        }
        if (mapped == null) {
            return this.EMPTY_METAS;
        }
        return mapped;
    }

    private ClassMetaData[] getImplementorMetaDatasInternal(Collection<Class<?>> classes, ClassLoader envLoader, boolean mustExist) {
        ArrayList<ClassMetaData> mapped = new ArrayList<ClassMetaData>(classes.size());
        ClassMetaData meta = null;
        for (Class<?> c : classes) {
            meta = this.getMetaData(c, envLoader, true);
            if (!meta.isMapped() && meta.getMappedPCSubclassMetaDatas().length <= 0) continue;
            mapped.add(meta);
        }
        return mapped.toArray(new ClassMetaData[mapped.size()]);
    }

    public NonPersistentMetaData getPersistenceAware(Class<?> cls) {
        return this._pawares.get(cls);
    }

    public boolean skipMetadata(Class<?> cls) {
        if (cls == null || cls.isEnum()) {
            return true;
        }
        if (this._typesWithoutEnhancement == null) {
            return false;
        }
        return this._typesWithoutEnhancement.stream().anyMatch(it -> it.isAssignableFrom(cls));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonPersistentMetaData[] getPersistenceAwares() {
        if (this._locking) {
            Map<Class<?>, NonPersistentMetaData> map = this._pawares;
            synchronized (map) {
                return this.getPersistenceAwaresInternal();
            }
        }
        return this.getPersistenceAwaresInternal();
    }

    private NonPersistentMetaData[] getPersistenceAwaresInternal() {
        if (this._pawares.isEmpty()) {
            return EMPTY_NON_PERSISTENT;
        }
        return this._pawares.values().toArray(new NonPersistentMetaData[this._pawares.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonPersistentMetaData addPersistenceAware(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this.addPersistenceAwareInternal(cls);
            }
        }
        return this.addPersistenceAwareInternal(cls);
    }

    private NonPersistentMetaData addPersistenceAwareInternal(Class<?> cls) {
        if (this._pawares.containsKey(cls)) {
            return this._pawares.get(cls);
        }
        if (this.getCachedMetaData(cls) != null) {
            throw new MetaDataException(_loc.get("pc-and-aware", cls));
        }
        NonPersistentMetaData meta = new NonPersistentMetaData(cls, this, 1);
        this._pawares.put(cls, meta);
        return meta;
    }

    public boolean removePersistenceAware(Class<?> cls) {
        return this._pawares.remove(cls) != null;
    }

    public NonPersistentMetaData getNonMappedInterface(Class<?> iface) {
        return this._nonMapped.get(iface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonPersistentMetaData[] getNonMappedInterfaces() {
        if (this._locking) {
            Map<Class<?>, NonPersistentMetaData> map = this._nonMapped;
            synchronized (map) {
                return this.getNonMappedInterfacesInternal();
            }
        }
        return this.getNonMappedInterfacesInternal();
    }

    private NonPersistentMetaData[] getNonMappedInterfacesInternal() {
        if (this._nonMapped.isEmpty()) {
            return EMPTY_NON_PERSISTENT;
        }
        return this._nonMapped.values().toArray(new NonPersistentMetaData[this._nonMapped.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonPersistentMetaData addNonMappedInterface(Class<?> iface) {
        if (iface == null) {
            return null;
        }
        if (!iface.isInterface()) {
            throw new MetaDataException(_loc.get("not-non-mapped", iface));
        }
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this.addNonMappedInterfaceInternal(iface);
            }
        }
        return this.addNonMappedInterfaceInternal(iface);
    }

    private NonPersistentMetaData addNonMappedInterfaceInternal(Class<?> iface) {
        if (this._nonMapped.containsKey(iface)) {
            return this._nonMapped.get(iface);
        }
        if (this.getCachedMetaData(iface) != null) {
            throw new MetaDataException(_loc.get("non-mapped-pc", iface));
        }
        NonPersistentMetaData meta = new NonPersistentMetaData(iface, this, 2);
        this._nonMapped.put(iface, meta);
        return meta;
    }

    public boolean removeNonMappedInterface(Class<?> iface) {
        return this._nonMapped.remove(iface) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("clear-repos", (Object)this));
        }
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                this.clearInternal();
            }
        } else {
            this.clearInternal();
        }
    }

    private void clearInternal() {
        this._metas.clear();
        this._oids.clear();
        this._subs.clear();
        this._impls.clear();
        this._queries.clear();
        this._seqs.clear();
        this._registered.clear();
        this._factory.clear();
        this._aliases.clear();
        this._pawares.clear();
        this._nonMapped.clear();
        this._metaStringMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPersistentTypeNames(boolean devpath, ClassLoader envLoader) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this.getPersistentTypeNamesInternal(devpath, envLoader);
            }
        }
        return this.getPersistentTypeNamesInternal(devpath, envLoader);
    }

    private Set<String> getPersistentTypeNamesInternal(boolean devpath, ClassLoader envLoader) {
        return this._factory.getPersistentTypeNames(devpath, envLoader);
    }

    public Collection<Class<?>> loadPersistentTypes(boolean devpath, ClassLoader envLoader) {
        return this.loadPersistentTypes(devpath, envLoader, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Class<?>> loadPersistentTypes(boolean devpath, ClassLoader envLoader, boolean mustExist) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this.loadPersistentTypesInternal(devpath, envLoader, mustExist);
            }
        }
        return this.loadPersistentTypesInternal(devpath, envLoader, mustExist);
    }

    private Collection<Class<?>> loadPersistentTypesInternal(boolean devpath, ClassLoader envLoader, boolean mustExist) {
        Set<String> names = this.getPersistentTypeNames(devpath, envLoader);
        if (names == null || names.isEmpty()) {
            if (!mustExist) {
                return Collections.emptyList();
            }
            throw new MetaDataException(_loc.get("eager-no-class-found"));
        }
        ClassLoader clsLoader = this._conf.getClassResolverInstance().getClassLoader(this.getClass(), envLoader);
        ArrayList classes = new ArrayList(names.size());
        for (String className : names) {
            Class<?> cls = this.classForName(className, clsLoader);
            if (this._factory.isMetaClass(cls)) {
                this.setMetaModel(cls);
                continue;
            }
            if (this.skipMetadata(cls)) continue;
            if (cls != null) {
                classes.add(cls);
                if (!cls.isInterface()) continue;
                this.getMetaData(cls, clsLoader, false);
                continue;
            }
            if (cls != null || !mustExist) continue;
            throw new MetaDataException(_loc.get("eager-class-not-found", (Object)className));
        }
        return classes;
    }

    private Class<?> classForName(String name, ClassLoader loader) {
        block13: {
            try {
                return Class.forName(name, true, loader);
            }
            catch (Exception e) {
                if ((this._validate & 8) != 0) {
                    if (this._log.isWarnEnabled()) {
                        this._log.warn((Object)_loc.get("bad-discover-class", (Object)name, (Object)loader));
                    }
                } else if (this._log.isInfoEnabled()) {
                    this._log.info((Object)_loc.get("bad-discover-class", (Object)name, (Object)loader));
                }
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)e);
                }
            }
            catch (NoSuchMethodError nsme) {
                if (nsme.getMessage().indexOf(".pc") == -1) {
                    throw nsme;
                }
                if ((this._validate & 8) != 0) {
                    if (this._log.isWarnEnabled()) {
                        this._log.warn((Object)_loc.get("bad-discover-class", (Object)name, (Object)loader));
                    }
                } else if (this._log.isInfoEnabled()) {
                    this._log.info((Object)_loc.get("bad-discover-class", (Object)name, (Object)loader));
                }
                if (!this._log.isTraceEnabled()) break block13;
                this._log.trace((Object)nsme);
            }
        }
        return null;
    }

    Collection<Class<?>> getPCSubclasses(Class<?> cls) {
        Collection<Class<?>> subs = this._subs.get(cls);
        if (subs == null) {
            return Collections.emptyList();
        }
        return subs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Class<?> cls) {
        Collection<Class<?>> collection = this._registered;
        synchronized (collection) {
            this._registered.add(cls);
            this.registerAlias(cls);
        }
    }

    private void loadRegisteredClassMetaData(ClassLoader envLoader) {
        Class<?>[] reg;
        for (Class<?> aClass : reg = this.processRegisteredClasses(envLoader)) {
            try {
                this.getMetaData(aClass, envLoader, false);
            }
            catch (MetaDataException me) {
                if (!this._log.isWarnEnabled()) continue;
                this._log.warn((Object)me);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Class<?>[] processRegisteredClasses(ClassLoader envLoader) {
        Class[] reg;
        Collection<Class<?>> collection = this._registered;
        synchronized (collection) {
            if (this._registered.isEmpty()) {
                return EMPTY_CLASSES;
            }
            reg = this._registered.toArray(new Class[this._registered.size()]);
            this._registered.clear();
        }
        Set<String> pcNames = this.getPersistentTypeNames(false, envLoader);
        ArrayList<Class> failed = null;
        for (Class aClass : reg) {
            block20: {
                if (pcNames != null && !pcNames.isEmpty() && !pcNames.contains(aClass.getName())) continue;
                if (this._filterRegisteredClasses) {
                    Log log = this._conf == null ? null : this._conf.getLog("openjpa.Runtime");
                    ClassLoader loadCL = envLoader != null ? envLoader : (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
                    try {
                        Class<?> classFromAppClassLoader = Class.forName(aClass.getName(), true, loadCL);
                        if (!aClass.equals(classFromAppClassLoader)) {
                            if (log == null || !log.isTraceEnabled()) continue;
                            log.trace((Object)("Metadata Repository will ignore Class " + aClass.getName() + ", since it originated from a ClassLoader not associated with the application."));
                            continue;
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (log == null || !log.isTraceEnabled()) break block20;
                        log.trace((Object)("The Class " + aClass.getName() + " was identified as a persistent class by configuration, but the Class could not be found."));
                    }
                }
            }
            this.checkEnhancementLevel(aClass);
            try {
                this.processRegisteredClass(aClass);
            }
            catch (Throwable t) {
                if (!this._conf.getRetryClassRegistration()) {
                    throw new MetaDataException(_loc.get("error-registered", (Object)aClass), t);
                }
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)_loc.get("failed-registered", (Object)aClass), t);
                }
                if (failed == null) {
                    failed = new ArrayList<Class>();
                }
                failed.add(aClass);
            }
        }
        if (failed != null) {
            if (this._locking) {
                Collection<Class<?>> collection2 = this._registered;
                synchronized (collection2) {
                    this._registered.addAll(failed);
                }
            } else {
                this._registered.addAll(failed);
            }
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRegisteredClass(Class<?> cls) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("process-registered", cls));
        }
        Class<?> leastDerived = cls;
        MetaDataRepository metaDataRepository = this;
        synchronized (metaDataRepository) {
            Class<?> anc = cls;
            while ((anc = PCRegistry.getPersistentSuperclass(anc)) != null) {
                this.addToCollection(this._subs, anc, cls, true);
                ClassMetaData meta = this._metas.get(anc);
                if (meta != null) {
                    meta.clearSubclassCache();
                }
                leastDerived = anc;
            }
        }
        Object oid = null;
        try {
            oid = PCRegistry.newObjectId(cls);
        }
        catch (InternalException meta) {
            // empty catch block
        }
        if (oid != null) {
            Class<?> existing = this._oids.get(oid.getClass());
            if (existing != null) {
                Class<?> sup = cls;
                while (PCRegistry.getPersistentSuperclass(sup) != null) {
                    sup = PCRegistry.getPersistentSuperclass(sup);
                }
                this._oids.put(oid.getClass(), sup);
            } else if (existing == null || cls.isAssignableFrom(existing)) {
                this._oids.put(oid.getClass(), cls);
            }
        }
        if (this._locking) {
            Map<Class<?>, Collection<Class<?>>> map = this._impls;
            synchronized (map) {
                this.updateImpls(cls, leastDerived, cls);
            }
        } else {
            this.updateImpls(cls, leastDerived, cls);
        }
        this.registerAlias(cls);
    }

    void registerAlias(Class<?> cls) {
        this.registerAlias(PCRegistry.getTypeAlias(cls), cls);
    }

    public void registerAlias(String alias, Class<?> cls) {
        if (alias == null) {
            return;
        }
        try {
            if (alias != null) {
                List<Class<?>> classes = this._aliases.get(alias);
                if (classes == null) {
                    classes = new ArrayList(3);
                }
                if (!classes.contains(cls)) {
                    classes.add(cls);
                    this._aliases.put(alias, classes);
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void updateImpls(Class<?> cls, Class<?> leastDerived, Class<?> check) {
        Class<?>[] ints;
        Class<?> sup = check.getSuperclass();
        if (leastDerived == cls && sup != null && sup != Object.class) {
            this.addToCollection(this._impls, sup, cls, false);
            this.updateImpls(cls, leastDerived, sup);
        }
        if (!this._factory.getDefaults().isDeclaredInterfacePersistent()) {
            return;
        }
        for (Class<?> anInt : ints = check.getInterfaces()) {
            if (anInt.getName().startsWith("java.") || leastDerived != cls && !this.isLeastDerivedImpl(anInt, cls)) continue;
            this.addToCollection(this._impls, anInt, cls, false);
            this.updateImpls(cls, leastDerived, anInt);
        }
    }

    private boolean isLeastDerivedImpl(Class<?> inter, Class<?> cls) {
        Class<?> parent = PCRegistry.getPersistentSuperclass(cls);
        while (parent != null) {
            if (Arrays.asList(parent.getInterfaces()).contains(inter)) {
                return false;
            }
            parent = PCRegistry.getPersistentSuperclass(parent);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCollection(Map<Class<?>, Collection<Class<?>>> map, Class<?> key, Class<?> value, boolean inheritance) {
        if (this._locking) {
            Map<Class<?>, Collection<Class<?>>> map2 = map;
            synchronized (map2) {
                this.addToCollectionInternal(map, key, value, inheritance);
            }
        } else {
            this.addToCollectionInternal(map, key, value, inheritance);
        }
    }

    private void addToCollectionInternal(Map<Class<?>, Collection<Class<?>>> map, Class<?> key, Class<?> value, boolean inheritance) {
        Collection<Class<?>> coll = map.get(key);
        if (coll == null) {
            if (inheritance) {
                InheritanceComparator comp = new InheritanceComparator();
                comp.setBase(key);
                coll = new TreeSet(comp);
            } else {
                coll = new LinkedList();
            }
            map.put(key, coll);
        }
        coll.add(value);
    }

    public void setMetaModel(Class<?> m2) {
        Class<?> cls = this._factory.getManagedClass(m2);
        if (cls != null) {
            this._metamodel.put(cls, m2);
        }
    }

    public void setMetaModel(ClassMetaData meta, Class<?> m2) {
        this._metamodel.put(meta.getDescribedType(), m2);
    }

    public Class<?> getMetaModel(ClassMetaData meta, boolean load) {
        return this.getMetaModel(meta.getDescribedType(), load);
    }

    public Class<?> getMetaModel(Class<?> entity, boolean load) {
        if (this._metamodel.containsKey(entity)) {
            return this._metamodel.get(entity);
        }
        String m2 = this._factory.getMetaModelClassName(entity.getName());
        try {
            ClassLoader loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(entity));
            Class m2cls = (Class)AccessController.doPrivileged(J2DoPrivHelper.getForNameAction((String)m2, (boolean)true, (ClassLoader)loader));
            this._metamodel.put(entity, m2cls);
            return m2cls;
        }
        catch (Throwable t) {
            if (this._log.isTraceEnabled()) {
                this._log.warn((Object)_loc.get("meta-no-model", (Object)m2, entity, (Object)t));
            }
            return null;
        }
    }

    public void setConfiguration(Configuration conf) {
        this._conf = (OpenJPAConfiguration)conf;
        this._log = this._conf.getLog("openjpa.MetaData");
        this._filterRegisteredClasses = this._conf.getCompatibilityInstance().getFilterPCRegistryClasses();
        this._typesWithoutEnhancement = this._conf.getTypesWithoutEnhancement();
        if (this._typesWithoutEnhancement == null || this._typesWithoutEnhancement.isEmpty()) {
            this._typesWithoutEnhancement = null;
        }
    }

    public void startConfiguration() {
    }

    public void endConfiguration() {
        this.initializeMetaDataFactory();
        if (this._implGen == null) {
            this._implGen = new InterfaceImplGenerator(this);
        }
        if (this._preload) {
            this._oids = new HashMap();
            this._impls = new HashMap();
            this._ifaces = new HashMap();
            this._aliases = new HashMap();
            this._pawares = new HashMap();
            this._nonMapped = new HashMap();
            this._subs = new HashMap();
        }
    }

    private void initializeMetaDataFactory() {
        if (this._factory == null) {
            MetaDataFactory mdf = this._conf.newMetaDataFactoryInstance();
            if (mdf == null) {
                throw new MetaDataException(_loc.get("no-metadatafactory"));
            }
            this.setMetaDataFactory(mdf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryMetaData getQueryMetaData(Class<?> cls, String name, ClassLoader envLoader, boolean mustExist) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this.getQueryMetaDataInternal(cls, name, envLoader, mustExist);
            }
        }
        return this.getQueryMetaDataInternal(cls, name, envLoader, mustExist);
    }

    private QueryMetaData getQueryMetaDataInternal(Class<?> cls, String name, ClassLoader envLoader, boolean mustExist) {
        QueryMetaData meta = this.getQueryMetaDataInternal(cls, name, envLoader);
        if (meta == null) {
            this.resolveAll(envLoader);
            meta = this.getQueryMetaDataInternal(cls, name, envLoader);
        }
        if (meta == null && mustExist) {
            if (cls == null) {
                throw new MetaDataException(_loc.get("no-named-query-null-class", this.getPersistentTypeNames(false, envLoader), (Object)name));
            }
            throw new MetaDataException(_loc.get("no-named-query", cls, (Object)name));
        }
        return meta;
    }

    private void resolveAll(ClassLoader envLoader) {
        Collection<Class<?>> types = this.loadPersistentTypes(false, envLoader);
        for (Class<?> c : types) {
            this.getMetaData(c, envLoader, false);
        }
    }

    private QueryMetaData getQueryMetaDataInternal(Class<?> cls, String name, ClassLoader envLoader) {
        if (name == null) {
            return null;
        }
        QueryMetaData qm = this._queries.get(name);
        if (qm != null) {
            return qm;
        }
        if (cls == null) {
            cls = this._factory.getQueryScope(name, envLoader);
        }
        if (cls != null && this.getMetaData(cls, envLoader, false) != null && (qm = this._queries.get(name)) != null) {
            return qm;
        }
        if ((this._sourceMode & 4) == 0) {
            return null;
        }
        this._factory.load(cls, 4, envLoader);
        return this._queries.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryMetaData[] getQueryMetaDatas() {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this._queries.values().toArray(new QueryMetaData[this._queries.size()]);
            }
        }
        return this._queries.values().toArray(new QueryMetaData[this._queries.size()]);
    }

    public QueryMetaData getCachedQueryMetaData(Class<?> cls, String name) {
        return this.getCachedQueryMetaData(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryMetaData getCachedQueryMetaData(String name) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this._queries.get(name);
            }
        }
        return this._queries.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryMetaData addQueryMetaData(Class<?> cls, String name) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                QueryMetaData meta = this.newQueryMetaData(cls, name);
                this._queries.put(name, meta);
                return meta;
            }
        }
        QueryMetaData meta = this.newQueryMetaData(cls, name);
        this._queries.put(name, meta);
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryMetaData addQueryMetaData(QueryMetaData meta) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                QueryMetaData queryMetaData = this._queries.get(meta.getName());
                return queryMetaData != null ? queryMetaData : this._queries.put(meta.getName(), meta);
            }
        }
        QueryMetaData queryMetaData = this._queries.get(meta.getName());
        return queryMetaData != null ? queryMetaData : this._queries.put(meta.getName(), meta);
    }

    public QueryMetaData newQueryMetaData(Class<?> cls, String name) {
        QueryMetaData meta = new QueryMetaData(name, this._conf.getCompatibilityInstance().getConvertPositionalParametersToNamed());
        meta.setDefiningType(cls);
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeQueryMetaData(QueryMetaData meta) {
        if (meta == null) {
            return false;
        }
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this._queries.remove(meta.getName()) != null;
            }
        }
        return this._queries.remove(meta.getName()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeQueryMetaData(Class<?> cls, String name) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                if (name == null) {
                    return false;
                }
                return this._queries.remove(name) != null;
            }
        }
        if (name == null) {
            return false;
        }
        return this._queries.remove(name) != null;
    }

    public QueryMetaData searchQueryMetaDataByName(String name) {
        return this._queries.get(name);
    }

    protected static Object getQueryKey(Class<?> cls, String name) {
        if (cls == null) {
            return name;
        }
        QueryKey key = new QueryKey();
        key.clsName = cls.getName();
        key.name = name;
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceMetaData getSequenceMetaData(String name, ClassLoader envLoader, boolean mustExist) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this.getSequenceMetaDataInternal(name, envLoader, mustExist);
            }
        }
        return this.getSequenceMetaDataInternal(name, envLoader, mustExist);
    }

    private SequenceMetaData getSequenceMetaDataInternal(String name, ClassLoader envLoader, boolean mustExist) {
        SequenceMetaData meta = this.getSequenceMetaDataInternal(name, envLoader);
        if (meta == null && "system".equals(name)) {
            if (this._sysSeq == null) {
                this._sysSeq = this.newSequenceMetaData(name);
            }
            return this._sysSeq;
        }
        if (meta == null && mustExist) {
            throw new MetaDataException(_loc.get("no-named-sequence", (Object)name));
        }
        return meta;
    }

    SequenceMetaData getSequenceMetaData(ClassMetaData context, String name, boolean mustExist) {
        MetaDataException e = null;
        try {
            SequenceMetaData seq = this.getSequenceMetaData(name, context.getEnvClassLoader(), mustExist);
            if (seq != null) {
                return seq;
            }
        }
        catch (MetaDataException mde) {
            e = mde;
        }
        if (name.indexOf(46) != -1) {
            if (e != null) {
                throw e;
            }
            return null;
        }
        name = ClassUtil.getPackageName(context.getDescribedType()) + "." + name;
        try {
            return this.getSequenceMetaData(name, context.getEnvClassLoader(), mustExist);
        }
        catch (MetaDataException mde) {
            if (e != null) {
                throw e;
            }
            throw mde;
        }
    }

    private SequenceMetaData getSequenceMetaDataInternal(String name, ClassLoader envLoader) {
        if (name == null) {
            return null;
        }
        SequenceMetaData meta = this._seqs.get(name);
        if (meta == null) {
            this.loadRegisteredClassMetaData(envLoader);
            meta = this._seqs.get(name);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceMetaData[] getSequenceMetaDatas() {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this._seqs.values().toArray(new SequenceMetaData[this._seqs.size()]);
            }
        }
        return this._seqs.values().toArray(new SequenceMetaData[this._seqs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceMetaData getCachedSequenceMetaData(String name) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this._seqs.get(name);
            }
        }
        return this._seqs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceMetaData addSequenceMetaData(String name) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                SequenceMetaData meta = this.newSequenceMetaData(name);
                this._seqs.put(name, meta);
                return meta;
            }
        }
        SequenceMetaData meta = this.newSequenceMetaData(name);
        this._seqs.put(name, meta);
        return meta;
    }

    protected SequenceMetaData newSequenceMetaData(String name) {
        return new SequenceMetaData(name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSequenceMetaData(SequenceMetaData meta) {
        if (meta == null) {
            return false;
        }
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this._seqs.remove(meta.getName()) != null;
            }
        }
        return this._seqs.remove(meta.getName()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSequenceMetaData(String name) {
        if (name == null) {
            return false;
        }
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this._seqs.remove(name) != null;
            }
        }
        return this._seqs.remove(name) != null;
    }

    public boolean is_systemListenersActivated() {
        return this._systemListenersActivated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemListener(Object listener) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                LifecycleEventManager.ListenerList listeners = new LifecycleEventManager.ListenerList(this._listeners);
                listeners.add(listener);
                this._listeners = listeners;
                this._systemListenersActivated = true;
            }
        } else {
            LifecycleEventManager.ListenerList listeners = new LifecycleEventManager.ListenerList(this._listeners);
            listeners.add(listener);
            this._listeners = listeners;
            this._systemListenersActivated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSystemListener(Object listener) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this.removeSystemListenerInternal(listener);
            }
        }
        return this.removeSystemListenerInternal(listener);
    }

    private boolean removeSystemListenerInternal(Object listener) {
        if (!this._listeners.contains(listener)) {
            return false;
        }
        LifecycleEventManager.ListenerList listeners = new LifecycleEventManager.ListenerList(this._listeners);
        listeners.remove(listener);
        this._listeners = listeners;
        return true;
    }

    public LifecycleEventManager.ListenerList getSystemListeners() {
        return this._listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                this.closeInternal();
            }
        } else {
            this.closeInternal();
        }
    }

    private void closeInternal() {
        SequenceMetaData[] smds;
        for (SequenceMetaData smd : smds = this.getSequenceMetaDatas()) {
            smd.close();
        }
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLMetaData getXMLMetaData(Class<?> cls) {
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                return this.getXMLMetaDataInternal(cls);
            }
        }
        return this.getXMLMetaDataInternal(cls);
    }

    private XMLMetaData getXMLMetaDataInternal(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        XMLMetaData xmlmeta = this._xmlmetas.get(cls);
        if (xmlmeta != null) {
            return xmlmeta;
        }
        this._factory.loadXMLMetaData(cls);
        xmlmeta = this._xmlmetas.get(cls);
        return xmlmeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLClassMetaData addXMLClassMetaData(Class<?> type) {
        XMLClassMetaData meta = this.newXMLClassMetaData(type);
        if (this._locking) {
            MetaDataRepository metaDataRepository = this;
            synchronized (metaDataRepository) {
                this._xmlmetas.put(type, meta);
            }
        } else {
            this._xmlmetas.put(type, meta);
        }
        return meta;
    }

    public XMLMetaData getCachedXMLMetaData(Class<?> cls) {
        return this._xmlmetas.get(cls);
    }

    protected XMLClassMetaData newXMLClassMetaData(Class<?> type) {
        return new XMLClassMetaData(type);
    }

    public XMLFieldMetaData newXMLFieldMetaData(Class<?> type, String name) {
        return new XMLFieldMetaData(type, name);
    }

    public static boolean needsPreload(OpenJPAConfiguration conf) {
        if (conf == null) {
            return false;
        }
        Options o = Configurations.parseProperties((String)Configurations.getProperties((String)conf.getMetaDataRepository()));
        return o.getBooleanProperty(PRELOAD_STR) || o.getBooleanProperty(PRELOAD_STR.toLowerCase());
    }

    private void checkEnhancementLevel(Class<?> cls) {
        if (!this._logEnhancementLevel) {
            return;
        }
        Log log = this._conf.getLog("openjpa.Runtime");
        boolean res = PCEnhancer.checkEnhancementLevel(cls, this._conf.getLog("openjpa.Runtime"));
        if (!log.isTraceEnabled() && res) {
            this._logEnhancementLevel = false;
            log.info((Object)_loc.get("down-level-entity"));
        }
    }

    public ClassMetaData getCachedMetaData(String typeName) {
        ClassMetaData cmd = this._metaStringMap.get(typeName);
        if (cmd == null) {
            for (ClassMetaData c : this.getMetaDatas()) {
                if (!c.getDescribedType().getName().equals(typeName)) continue;
                this._metaStringMap.put(typeName, c);
                return c;
            }
        }
        return cmd;
    }

    private static class QueryKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String clsName;
        public String name;

        private QueryKey() {
        }

        public int hashCode() {
            int clsHash = this.clsName == null ? 0 : this.clsName.hashCode();
            int nameHash = this.name == null ? 0 : this.name.hashCode();
            return clsHash + nameHash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof QueryKey)) {
                return false;
            }
            QueryKey qk = (QueryKey)obj;
            return Objects.equals(this.clsName, qk.clsName) && Objects.equals(this.name, qk.name);
        }
    }
}

