/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.scheduler.resource;

import com.github.openjson.JSONObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Resource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Object id;
    private String text;
    private String color;
    private final Map<String, Object> fields = new HashMap<String, Object>();

    protected Resource(String id) {
        this(id, null, null);
    }

    protected Resource(Object id) {
        this(id, null, null);
    }

    public Resource(String id, String text) {
        this(id, text, null);
    }

    public Resource(Object id, String text) {
        this(id, text, null);
    }

    public Resource(String id, String text, String color) {
        this.id = id;
        this.text = text;
        this.color = color;
    }

    public Resource(Object id, String text, String color) {
        this.id = id;
        this.text = text;
        this.color = color;
    }

    public <T> T getId() {
        return (T)this.id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void set(String field, Object value) {
        this.fields.put(field, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)object;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return Resource.toJSONObject(this).toString();
    }

    public static JSONObject toJSONObject(Resource resource) {
        JSONObject object = new JSONObject();
        if (resource != null) {
            object.put("value", resource.id);
            object.put("text", (Object)resource.text);
            object.putOpt("color", (Object)resource.color);
            for (Map.Entry<String, Object> entry : resource.fields.entrySet()) {
                object.put(entry.getKey(), entry.getValue());
            }
        }
        return object;
    }
}

