/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.launcher;

import jakarta.json.JsonArray;
import java.io.File;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;
import org.apache.sling.feature.extension.apiregions.launcher.LauncherProperties;
import org.apache.sling.feature.launcher.spi.extensions.ExtensionContext;
import org.apache.sling.feature.launcher.spi.extensions.ExtensionHandler;

public class RegionLauncherExtension
implements ExtensionHandler {
    public static final String FEATURE_REGION_FILENAME = "features.properties";
    public static final String REGION_PACKAGE_FILENAME = "regions.properties";

    public boolean handle(ExtensionContext extensionContext, Extension extension) throws Exception {
        if (!extension.getName().equals("api-regions")) {
            return false;
        }
        File base = File.createTempFile("apiregions", ".properties");
        base.delete();
        base.mkdirs();
        File featuresFile = new File(base, FEATURE_REGION_FILENAME);
        File regionsFile = new File(base, REGION_PACKAGE_FILENAME);
        ApiRegions apiRegions = ApiRegions.parse((JsonArray)extension.getJSONStructure());
        LauncherProperties.save(LauncherProperties.getFeatureIDtoRegionsMap(apiRegions), featuresFile);
        LauncherProperties.save(LauncherProperties.getRegionNametoPackagesMap(apiRegions), regionsFile);
        extensionContext.addFrameworkProperty("sling.feature.apiregions.resource.features.properties", featuresFile.toURI().toURL().toString());
        extensionContext.addFrameworkProperty("sling.feature.apiregions.resource.regions.properties", regionsFile.toURI().toURL().toString());
        return true;
    }
}

