/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.internal;

import com.google.inject.Injector;
import com.google.inject.Key;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Setting<T> {
    private static final Setting<Object> NULL_SETTING = new Setting<Object>(){

        @Override
        Object get(Injector injector) {
            return null;
        }
    };

    Setting() {
    }

    abstract T get(Injector var1);

    static <T> Setting<T> newSetting(final T instance) {
        if (null == instance) {
            throw new IllegalArgumentException("null instance");
        }
        return new Setting<T>(){
            private boolean configured;

            @Override
            synchronized T get(Injector injector) {
                if (!this.configured && null != injector) {
                    injector.injectMembers(instance);
                    this.configured = true;
                }
                return instance;
            }
        };
    }

    static <T> Setting<T> newSetting(final Key<? extends T> key) {
        if (null == key) {
            throw new IllegalArgumentException("null binding key");
        }
        return new Setting<T>(){
            private T instance;

            @Override
            synchronized T get(Injector injector) {
                if (null == this.instance) {
                    if (null == injector) {
                        throw new IllegalArgumentException("missing injector for setting: " + key);
                    }
                    this.instance = injector.getInstance(key);
                }
                return this.instance;
            }
        };
    }

    static <T> Setting<T> nullSetting() {
        return NULL_SETTING;
    }
}

