
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
 
 // Code generated by code-generation. DO NOT EDIT.

[type BACnetActionTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetAction
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetAction.DIRECT)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetAccessPassbackModeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetAccessPassbackMode
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetAccessPassbackMode.PASSBACK_OFF)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetAccessRuleLocationSpecifierTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetAccessRuleLocationSpecifier
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetAccessRuleLocationSpecifier.SPECIFIED)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetAccessRuleTimeRangeSpecifierTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetAccessRuleTimeRangeSpecifier
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetAccessRuleTimeRangeSpecifier.SPECIFIED)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetAccumulatorRecordAccumulatorStatusTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetAccumulatorRecordAccumulatorStatus
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetAccumulatorRecordAccumulatorStatus.NORMAL)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetAuthenticationFactorTypeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetAuthenticationFactorType
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetAuthenticationFactorType.UNDEFINED)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetAuthenticationStatusTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetAuthenticationStatus
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetAuthenticationStatus.NOT_READY)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetBackupStateTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetBackupState
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetBackupState.IDLE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetBinaryPVTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetBinaryPV
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetBinaryPV.INACTIVE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetConfirmedServiceRequestConfirmedTextMessageMessagePriorityTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetConfirmedServiceRequestConfirmedTextMessageMessagePriority
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetConfirmedServiceRequestConfirmedTextMessageMessagePriority.NORMAL)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisableTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisable
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisable.ENABLE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilter
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilter.ALL)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilter.OFFNORMAL)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDeviceTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDevice
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDevice.COLDSTART)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetDoorSecuredStatusTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetDoorSecuredStatus
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetDoorSecuredStatus.SECURED)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetDoorValueTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetDoorValue
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetDoorValue.LOCK)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetFaultTypeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetFaultType
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetFaultType.NONE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetFileAccessMethodTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetFileAccessMethod
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetFileAccessMethod.RECORD_ACCESS)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetIPModeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetIPMode
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetIPMode.NORMAL)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetLiftCarDoorCommandTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetLiftCarDoorCommand
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetLiftCarDoorCommand.NONE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetLiftGroupModeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetLiftGroupMode
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetLiftGroupMode.UNKNOWN)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetLightingInProgressTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetLightingInProgress
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetLightingInProgress.IDLE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetLockStatusTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetLockStatus
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetLockStatus.LOCKED)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetNetworkNumberQualityTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetNetworkNumberQuality
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetNetworkNumberQuality.UNKNOWN)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetNodeTypeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetNodeType
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetNodeType.UNKNOWN)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetNotifyTypeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetNotifyType
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetNotifyType.ALARM)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetPolarityTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetPolarity
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetPolarity.NORMAL)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetProgramRequestTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetProgramRequest
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetProgramRequest.READY)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetProgramStateTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetProgramState
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetProgramState.IDLE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetProtocolLevelTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetProtocolLevel
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetProtocolLevel.PHYSICAL)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetRouterEntryStatusTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetRouterEntryStatus
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetRouterEntryStatus.AVAILABLE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetSecurityLevelTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetSecurityLevel
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetSecurityLevel.INCAPABLE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetSecurityPolicyTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetSecurityPolicy
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetSecurityPolicy.PLAIN_NON_TRUSTED)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetSegmentationTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetSegmentation
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetSegmentation.SEGMENTED_BOTH)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetShedStateTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetShedState
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetShedState.SHED_INACTIVE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetTimerStateTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetTimerState
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetTimerState.IDLE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetTimerTransitionTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetTimerTransition
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetTimerTransition.NONE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetUnconfirmedServiceChoiceTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetUnconfirmedServiceChoice
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetUnconfirmedServiceChoice.I_AM)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BACnetWriteStatusTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BACnetWriteStatus
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BACnetWriteStatus.IDLE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type BVLCResultCodeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   BVLCResultCode
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, BVLCResultCode.SUCCESSFUL_COMPLETION)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type NPDUNetworkPriorityTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   NPDUNetworkPriority
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, NPDUNetworkPriority.LIFE_SAVETY_MESSAGE)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

[type SecurityResponseCodeTagged(uint 8 tagNumber, TagClass tagClass)
    [simple   BACnetTagHeader
                        header                                                                                  ]
    [validation    'header.tagClass == tagClass'    "tag class doesn't match"                                   ]
    [validation    '(header.tagClass == TagClass.APPLICATION_TAGS) || (header.actualTagNumber == tagNumber)'
                                                    "tagnumber doesn't match" shouldFail=false                  ]
    [manual   SecurityResponseCode
                    value
                        'STATIC_CALL("readEnumGenericFailing", readBuffer, header.actualLength, SecurityResponseCode.SUCCESS)'
                        'STATIC_CALL("writeEnumGeneric", writeBuffer, value)'
                        'header.actualLength * 8'                                                               ]
]

