/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.command.process;

import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.nifi.bootstrap.command.process.ManagementServerAddressProvider;
import org.apache.nifi.bootstrap.configuration.SystemProperty;

public class VirtualMachineManagementServerAddressProvider
implements ManagementServerAddressProvider {
    private final ProcessHandle processHandle;

    public VirtualMachineManagementServerAddressProvider(ProcessHandle processHandle) {
        this.processHandle = Objects.requireNonNull(processHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> getAddress() {
        String managementServerAddress = null;
        String applicationProcessId = Long.toString(this.processHandle.pid());
        try {
            VirtualMachine virtualMachine = VirtualMachine.attach(applicationProcessId);
            try {
                managementServerAddress = this.getAddress(virtualMachine);
            }
            finally {
                virtualMachine.detach();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.ofNullable(managementServerAddress);
    }

    private String getAddress(VirtualMachine virtualMachine) throws IOException {
        Properties systemProperties = virtualMachine.getSystemProperties();
        return systemProperties.getProperty(SystemProperty.MANAGEMENT_SERVER_ADDRESS.getProperty());
    }
}

