/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.sse;

import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicHttpResponse;
import org.apache.knox.gateway.sse.SSEEntity;

public class SSEResponse
extends BasicHttpResponse {
    private final HttpResponse inboundResponse;
    private final SSEEntity entity;

    public SSEResponse(HttpResponse inboundResponse) {
        super(inboundResponse.getStatusLine());
        this.inboundResponse = inboundResponse;
        this.entity = new SSEEntity(inboundResponse.getEntity());
    }

    public SSEEntity getEntity() {
        return this.entity;
    }

    public StatusLine getStatusLine() {
        return this.inboundResponse.getStatusLine();
    }

    public void setStatusLine(StatusLine statusline) {
        this.inboundResponse.setStatusLine(statusline);
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        this.inboundResponse.setStatusLine(ver, code);
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.inboundResponse.setStatusLine(ver, code, reason);
    }

    public void setStatusCode(int code) throws IllegalStateException {
        this.inboundResponse.setStatusCode(code);
    }

    public void setReasonPhrase(String reason) throws IllegalStateException {
        this.inboundResponse.setReasonPhrase(reason);
    }

    public Locale getLocale() {
        return this.inboundResponse.getLocale();
    }

    public void setLocale(Locale loc) {
        this.inboundResponse.setLocale(loc);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.inboundResponse.getProtocolVersion();
    }

    public boolean containsHeader(String name) {
        return this.inboundResponse.containsHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.inboundResponse.getHeaders(name);
    }

    public Header getFirstHeader(String name) {
        return this.inboundResponse.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.inboundResponse.getLastHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.inboundResponse.getAllHeaders();
    }

    public void addHeader(Header header) {
        this.inboundResponse.addHeader(header);
    }

    public void addHeader(String name, String value) {
        this.inboundResponse.addHeader(name, value);
    }

    public void setHeader(Header header) {
        this.inboundResponse.setHeader(header);
    }

    public void setHeader(String name, String value) {
        this.inboundResponse.setHeader(name, value);
    }

    public void setHeaders(Header[] headers) {
        this.inboundResponse.setHeaders(headers);
    }

    public void removeHeader(Header header) {
        this.inboundResponse.removeHeader(header);
    }

    public void removeHeaders(String name) {
        this.inboundResponse.removeHeaders(name);
    }

    public HeaderIterator headerIterator() {
        return this.inboundResponse.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.inboundResponse.headerIterator(name);
    }
}

