/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hive;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGeneratorHandleResponse;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class HiveServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "HIVE";
    public static final String SERVICE_TYPE = "HIVE";
    public static final String ROLE_TYPE = "HIVESERVER2";
    static final String TRANSPORT_MODE_HTTP = "http";
    static final String TRANSPORT_MODE_ALL = "all";
    static final String SAFETY_VALVE = "hive_hs2_config_safety_valve";
    public static final String SSL_ENABLED = "hiveserver2_enable_ssl";
    static final String TRANSPORT_MODE = "hive.server2.transport.mode";
    static final String HTTP_PORT = "hive.server2.thrift.http.port";
    static final String HTTP_PATH = "hive.server2.thrift.http.path";
    static final String DEFAULT_HTTP_PATH = "cliservice";

    @Override
    public String getService() {
        return "HIVE";
    }

    @Override
    public String getServiceType() {
        return "HIVE";
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModelGeneratorHandleResponse handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        ServiceModelGeneratorHandleResponse response = super.handles(service, serviceConfig, role, roleConfig);
        if (response.handled()) {
            this.checkHiveServer2HTTPMode(roleConfig, response);
        }
        return response;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        String hostname = role.getHostRef().getHostname();
        boolean sslEnabled = Boolean.parseBoolean(this.getServiceConfigValue(serviceConfig, SSL_ENABLED));
        String scheme = sslEnabled ? "https" : TRANSPORT_MODE_HTTP;
        String port = this.getHttpPort(roleConfig);
        String httpPath = this.getHttpPath(roleConfig);
        if (httpPath == null) {
            httpPath = DEFAULT_HTTP_PATH;
        }
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s/%s", scheme, hostname, port, httpPath));
        model.addServiceProperty(SSL_ENABLED, Boolean.toString(sslEnabled));
        model.addRoleProperty(this.getRoleType(), SAFETY_VALVE, this.getRoleConfigValue(roleConfig, SAFETY_VALVE));
        return model;
    }

    private String getHS2SafetyValveValue(ApiConfigList roleConfig, String name) {
        String value = null;
        String hs2SafetyValve = this.getRoleConfigValue(roleConfig, SAFETY_VALVE);
        if (hs2SafetyValve != null && !hs2SafetyValve.isEmpty()) {
            value = this.getSafetyValveValue(hs2SafetyValve, name);
        }
        return value;
    }

    protected String getHttpPort(ApiConfigList roleConfig) {
        return this.getHS2SafetyValveValue(roleConfig, HTTP_PORT);
    }

    protected String getHttpPath(ApiConfigList roleConfig) {
        return this.getHS2SafetyValveValue(roleConfig, HTTP_PATH);
    }

    protected void checkHiveServer2HTTPMode(ApiConfigList roleConfig, ServiceModelGeneratorHandleResponse response) {
        String hiveServer2SafetyValve = this.getRoleConfigValue(roleConfig, SAFETY_VALVE);
        String hiveServer2TransportMode = hiveServer2SafetyValve == null ? null : this.getSafetyValveValue(hiveServer2SafetyValve, TRANSPORT_MODE);
        this.validateTransportMode(TRANSPORT_MODE, hiveServer2TransportMode, response);
    }

    protected void validateTransportMode(String configPropName, String transportMode, ServiceModelGeneratorHandleResponse response) {
        if (transportMode == null) {
            response.addConfigurationIssue("Missing configuration: " + configPropName);
        } else if (!TRANSPORT_MODE_HTTP.equalsIgnoreCase(transportMode) && !TRANSPORT_MODE_ALL.equalsIgnoreCase(transportMode)) {
            response.addConfigurationIssue("Invalid configuration: " + configPropName + ". Expected=" + TRANSPORT_MODE_HTTP + " or " + TRANSPORT_MODE_ALL + "; Found=" + transportMode);
        }
    }
}

