/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.settings;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.components.ColoredRadioButton;
import com.github.weisj.darklaf.components.DynamicUI;
import com.github.weisj.darklaf.components.tooltip.ToolTipContext;
import com.github.weisj.darklaf.components.tristate.TristateCheckBox;
import com.github.weisj.darklaf.components.tristate.TristateState;
import com.github.weisj.darklaf.graphics.ThemedColor;
import com.github.weisj.darklaf.listener.UIUpdater;
import com.github.weisj.darklaf.platform.ThemePreferencesHandler;
import com.github.weisj.darklaf.platform.macos.theme.MacOSColors;
import com.github.weisj.darklaf.settings.RadioColorChooser;
import com.github.weisj.darklaf.settings.SettingsConfiguration;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.info.AccentColorRule;
import com.github.weisj.darklaf.theme.info.FontSizePreset;
import com.github.weisj.darklaf.theme.info.FontSizeRule;
import com.github.weisj.darklaf.theme.info.PreferredThemeStyle;
import com.github.weisj.darklaf.ui.slider.DarkSliderUI;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.function.Function;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;

public class ThemeSettingsUI {
    public static final String THEME_LABEL_KEY = "label_theme";
    public static final String SELECTION_COLOR_LABEL_KEY = "label_selection_color";
    public static final String ACCENT_COLOR_LABEL_KEY = "label_accent_color";
    public static final String FONT_SIZE_LABEL_KEY = "label_font_size";
    public static final String GENERAL_LABEL_KEY = "title_general";
    public static final String MONITORING_LABEL_KEY = "title_monitoring";
    private final SettingsUIConfiguration settingsConfiguration;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final JComboBox<Theme> themeComboBox;
    private final RadioColorChooser selectionChooser;
    private final RadioColorChooser accentChooser;
    private final JSlider fontSlider;
    private final TristateCheckBox enabledSystemPreferences;
    private final JCheckBox fontSizeFollowsSystem;
    private final JCheckBox accentColorFollowsSystem;
    private final JCheckBox selectionColorFollowsSystem;
    private final JCheckBox themeFollowsSystem;

    public ThemeSettingsUI() {
        this.settingsConfiguration = new SettingsUIConfiguration();
        Color currentAccentColor = LafManager.getTheme().getAccentColorRule().getAccentColor();
        Color currentSelectionColor = LafManager.getTheme().getAccentColorRule().getSelectionColor();
        this.themeComboBox = ThemeSettingsUI.createThemeComboBox();
        this.accentChooser = ThemeSettingsUI.createAccentColorChooser(currentAccentColor);
        this.selectionChooser = ThemeSettingsUI.createSelectionColorChooser(currentSelectionColor);
        List<ColoredRadioButton> accentButtons = this.accentChooser.getRadioButtons();
        List<ColoredRadioButton> selectionButtons = this.selectionChooser.getRadioButtons();
        for (int i = 0; i < accentButtons.size(); ++i) {
            ColoredRadioButton button = accentButtons.get(i);
            ColoredRadioButton peer = selectionButtons.get(i);
            button.addActionListener(e -> {
                if (button.isSelected()) {
                    peer.setSelected(true);
                }
            });
        }
        this.fontSlider = ThemeSettingsUI.createFontSlider();
        this.enabledSystemPreferences = DynamicUI.withDynamic(new TristateCheckBox(), c -> c.setText(UIManager.getString((Object)"check_system_preferences", c.getLocale())));
        this.accentColorFollowsSystem = ThemeSettingsUI.createSystemSettingCheckBox("check_system_accent_color", ThemePreferencesHandler::supportsNativeAccentColor);
        this.selectionColorFollowsSystem = ThemeSettingsUI.createSystemSettingCheckBox("check_system_selection_color", ThemePreferencesHandler::supportsNativeSelectionColor);
        this.fontSizeFollowsSystem = ThemeSettingsUI.createSystemSettingCheckBox("check_system_font", ThemePreferencesHandler::supportsNativeFontSize);
        this.themeFollowsSystem = ThemeSettingsUI.createSystemSettingCheckBox("check_system_theme", ThemePreferencesHandler::supportsNativeTheme);
        this.setupListeners();
    }

    private void setupListeners() {
        this.themeComboBox.addItemListener(e -> this.update());
        this.enabledSystemPreferences.addChangeListener(e -> {
            if (!this.enabledSystemPreferences.getTristateModel().isIndeterminate()) {
                boolean selected = this.enabledSystemPreferences.getTristateModel().isSelected();
                if (this.themeFollowsSystem.isEnabled()) {
                    this.themeFollowsSystem.setSelected(selected);
                }
                if (this.accentColorFollowsSystem.isEnabled()) {
                    this.accentColorFollowsSystem.setSelected(selected);
                }
                if (this.selectionColorFollowsSystem.isEnabled()) {
                    this.selectionColorFollowsSystem.setSelected(selected);
                }
                if (this.fontSizeFollowsSystem.isEnabled()) {
                    this.fontSizeFollowsSystem.setSelected(selected);
                }
            }
            this.update();
        });
        this.themeFollowsSystem.addActionListener(e -> this.update());
        this.accentColorFollowsSystem.addActionListener(e -> this.update());
        this.selectionColorFollowsSystem.addActionListener(e -> this.update());
        this.fontSizeFollowsSystem.addActionListener(e -> this.update());
        this.enabledSystemPreferences.setSelected(LafManager.isPreferenceChangeReportingEnabled());
    }

    private void update() {
        boolean enabled = !this.enabledSystemPreferences.getTristateModel().isDeselected();
        this.enabledSystemPreferences.setEnabled(this.settingsConfiguration.isSystemPreferencesSupported());
        this.themeFollowsSystem.setEnabled(enabled && this.settingsConfiguration.isSystemThemeSupported());
        this.accentColorFollowsSystem.setEnabled(enabled && this.settingsConfiguration.isSystemAccentColorSupported());
        this.selectionColorFollowsSystem.setEnabled(enabled && this.settingsConfiguration.isSystemSelectionColorSupported());
        this.fontSizeFollowsSystem.setEnabled(enabled && this.settingsConfiguration.isSystemFontSizeSupported());
        this.settingsConfiguration.setSystemPreferencesEnabled(this.settingsConfiguration.isSystemPreferencesEnabled());
        this.accentChooser.setEnabled(!this.settingsConfiguration.isAccentColorFollowsSystem() && this.settingsConfiguration.getSelectedTheme().supportsCustomAccentColor());
        this.selectionChooser.setEnabled(!this.settingsConfiguration.isSelectionColorFollowsSystem() && this.settingsConfiguration.getSelectedTheme().supportsCustomSelectionColor());
        this.themeComboBox.setEnabled(!this.settingsConfiguration.isThemeFollowsSystem());
        this.fontSlider.setEnabled(!this.settingsConfiguration.isFontSizeFollowsSystem());
        if (!this.listeners.isEmpty()) {
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener listener : this.listeners) {
                listener.stateChanged(e);
            }
        }
    }

    protected void setAccentColor(Color accentColor) {
        this.accentChooser.setColor(accentColor);
    }

    protected void setSelectionColor(Color selectionColor) {
        this.selectionChooser.setColor(selectionColor);
    }

    public void loadConfiguration(SettingsConfiguration configuration) {
        this.themeComboBox.setModel(LafManager.getThemeComboBoxModel());
        this.settingsConfiguration.load(configuration);
        this.settingsConfiguration.setAccentColorRule(this.settingsConfiguration.getAccentColorRule());
        this.update();
    }

    public SettingsConfiguration getSettingsConfiguration() {
        return this.settingsConfiguration;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public JComboBox<Theme> getThemeComboBox() {
        return this.themeComboBox;
    }

    public RadioColorChooser getSelectionChooser() {
        return this.selectionChooser;
    }

    public RadioColorChooser getAccentChooser() {
        return this.accentChooser;
    }

    public JSlider getFontSlider() {
        return this.fontSlider;
    }

    public TristateCheckBox getSystemPreferencesTristateCheckBox() {
        return this.enabledSystemPreferences;
    }

    public JCheckBox getAccentColorFollowsSystemCheckBox() {
        return this.accentColorFollowsSystem;
    }

    public JCheckBox getSelectionColorFollowsSystemCheckBox() {
        return this.selectionColorFollowsSystem;
    }

    public JCheckBox getFontSizeFollowsSystemCheckBox() {
        return this.fontSizeFollowsSystem;
    }

    public JCheckBox getThemeFollowsSystemCheckBox() {
        return this.themeFollowsSystem;
    }

    private static JComboBox<Theme> createThemeComboBox() {
        JComboBox<Theme> comboBox = new JComboBox<Theme>(LafManager.getThemeComboBoxModel());
        comboBox.setRenderer(LafManager.getThemeListCellRenderer());
        comboBox.putClientProperty("JComboBox.isTableCellEditor", true);
        return comboBox;
    }

    private static RadioColorChooser createAccentColorChooser(Color currentAccentColor) {
        ThemedColor defaultAccentColor = new ThemedColor("themeAccentColor");
        return new RadioColorChooser(Arrays.asList(new RadioColorChooser.ColorSpec(ColoredRadioButton.DEFAULT_COLOR, (Color)((Object)defaultAccentColor), "color_default"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_BLUE, null, "color_blue"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_LILAC, null, "color_lilac"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_ROSE, null, "color_rose"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_RED, null, "color_red"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_ORANGE, null, "color_orange"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_YELLOW, null, "color_yellow"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_GREEN, null, "color_green"), new RadioColorChooser.ColorSpec(MacOSColors.ACCENT_GRAPHITE, null, "color_gray")), new RadioColorChooser.ColorSpec(currentAccentColor, null, "color_custom"), currentAccentColor, (Color)((Object)defaultAccentColor));
    }

    private static RadioColorChooser createSelectionColorChooser(Color currentSelectionColor) {
        ThemedColor defaultSelectionColor = new ThemedColor("themeSelectionColor");
        return new RadioColorChooser(Arrays.asList(new RadioColorChooser.ColorSpec((Color)((Object)defaultSelectionColor), ColoredRadioButton.DEFAULT_COLOR, "color_default"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_BLUE, MacOSColors.ACCENT_BLUE, "color_blue"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_PURPLE, MacOSColors.ACCENT_LILAC, "color_purple"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_PINK, MacOSColors.ACCENT_ROSE, "color_pink"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_RED, MacOSColors.ACCENT_RED, "color_red"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_ORANGE, MacOSColors.ACCENT_ORANGE, "color_orange"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_YELLOW, MacOSColors.ACCENT_YELLOW, "color_yellow"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_GREEN, MacOSColors.ACCENT_GREEN, "color_green"), new RadioColorChooser.ColorSpec(MacOSColors.SELECTION_GRAPHITE, MacOSColors.ACCENT_GRAPHITE, "color_gray")), new RadioColorChooser.ColorSpec(currentSelectionColor, (Color)((Object)defaultSelectionColor), "color_custom"), currentSelectionColor, (Color)((Object)defaultSelectionColor));
    }

    private static JSlider createFontSlider() {
        JSlider fontSlider = new JSlider(){

            @Override
            public String getToolTipText(MouseEvent event) {
                return this.getValue() + "%";
            }
        };
        ToolTipContext context = new ToolTipContext().setAlignment(Alignment.CENTER).setCenterAlignment(Alignment.NORTH).setUseBestFit(true).setToolTipRectSupplier(e -> {
            SliderUI ui = fontSlider.getUI();
            if (ui instanceof DarkSliderUI) {
                Rectangle r = ((DarkSliderUI)ui).getThumbRect();
                --r.x;
                return r;
            }
            return new Rectangle(0, 0, fontSlider.getWidth(), fontSlider.getHeight());
        });
        fontSlider.putClientProperty("JSlider.instantScrollEnabled", true);
        fontSlider.putClientProperty("JSlider.useTrackAsBaseline", true);
        fontSlider.putClientProperty("JToolTip.toolTipContext", context);
        fontSlider.putClientProperty("JToolTip.style", "balloon");
        fontSlider.setToolTipText(String.valueOf(fontSlider.getValue()));
        fontSlider.setOrientation(0);
        fontSlider.setPaintTicks(true);
        fontSlider.setMinimum(FontSizePreset.TINY.getPercentage());
        fontSlider.setMaximum(FontSizePreset.HUGE.getPercentage());
        int tickSpacing = 25;
        Hashtable<Integer, JComponent> dict = fontSlider.createStandardLabels(tickSpacing);
        JLabel min = (JLabel)((Dictionary)dict).get(fontSlider.getMinimum());
        UIUpdater.registerComponent(min);
        DynamicUI.withDynamic(min, c -> c.setText(UIManager.getString((Object)"label_font_smaller", fontSlider.getLocale())));
        min.setAlignmentX(0.0f);
        min.putClientProperty("JSlider.manualLabelAlign", true);
        JLabel mid = (JLabel)((Dictionary)dict).get(fontSlider.getMinimum() + tickSpacing);
        UIUpdater.registerComponent(mid);
        ((Dictionary)dict).remove(fontSlider.getMinimum() + tickSpacing);
        ((Dictionary)dict).put(FontSizePreset.NORMAL.getPercentage(), mid);
        DynamicUI.withDynamic(mid, c -> c.setText(UIManager.getString((Object)"label_font_default", fontSlider.getLocale())));
        mid.setAlignmentX(0.5f);
        mid.setHorizontalTextPosition(4);
        JLabel max = (JLabel)((Dictionary)dict).get(fontSlider.getMaximum());
        max.putClientProperty("JSlider.manualLabelAlign", true);
        DynamicUI.withDynamic(max, c -> c.setText(UIManager.getString((Object)"label_font_bigger", fontSlider.getLocale())));
        max.setAlignmentX(1.0f);
        max.putClientProperty("JSlider.manualLabelAlign", true);
        UIUpdater.registerComponent(max);
        ((Dictionary)dict).remove(FontSizePreset.Small.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.SMALL.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.Large.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.LARGE.getPercentage());
        ((Dictionary)dict).remove(FontSizePreset.Huge.getPercentage());
        fontSlider.setLabelTable(dict);
        fontSlider.setMajorTickSpacing(tickSpacing);
        fontSlider.setMinorTickSpacing(tickSpacing);
        fontSlider.setPaintLabels(true);
        fontSlider.setSnapToTicks(true);
        return fontSlider;
    }

    private static JCheckBox createSystemSettingCheckBox(String labelKey, final Function<ThemePreferencesHandler, Boolean> enabledCondition) {
        JCheckBox checkBox = DynamicUI.withDynamic(new JCheckBox(){

            @Override
            public void setEnabled(boolean b) {
                boolean enabled = b && (Boolean)enabledCondition.apply(ThemePreferencesHandler.getSharedInstance()) != false;
                super.setEnabled(enabled);
            }
        }, c -> c.setText(UIManager.getString((Object)labelKey, c.getLocale())));
        checkBox.setSelected(false);
        checkBox.setEnabled(false);
        return checkBox;
    }

    private class SettingsUIConfiguration
    extends SettingsConfiguration {
        private SettingsUIConfiguration() {
        }

        @Override
        public boolean isSystemPreferencesEnabled() {
            return !ThemeSettingsUI.this.enabledSystemPreferences.getTristateModel().isDeselected() && this.isSystemPreferencesSupported();
        }

        @Override
        public boolean isAccentColorFollowsSystem() {
            return ThemeSettingsUI.this.accentColorFollowsSystem.isSelected() && this.isSystemAccentColorSupported();
        }

        @Override
        public boolean isFontSizeFollowsSystem() {
            return ThemeSettingsUI.this.fontSizeFollowsSystem.isSelected() && this.isSystemFontSizeSupported();
        }

        @Override
        public boolean isSelectionColorFollowsSystem() {
            return ThemeSettingsUI.this.selectionColorFollowsSystem.isSelected() && this.isSystemSelectionColorSupported();
        }

        @Override
        public boolean isThemeFollowsSystem() {
            return ThemeSettingsUI.this.themeFollowsSystem.isSelected() && this.isSystemThemeSupported();
        }

        @Override
        public boolean isSystemAccentColorSupported() {
            return super.isSystemAccentColorSupported() && this.getSelectedTheme().supportsCustomAccentColor();
        }

        @Override
        public boolean isSystemSelectionColorSupported() {
            return super.isSystemSelectionColorSupported() && this.getSelectedTheme().supportsCustomSelectionColor();
        }

        private Color getSelectedColor(RadioColorChooser chooser) {
            Color c = chooser.getSelectedColor();
            return c == chooser.getDefaultColor() ? null : c;
        }

        @Override
        public AccentColorRule getAccentColorRule() {
            boolean useSystemAccent = this.isAccentColorFollowsSystem();
            boolean useSystemSelection = this.isSelectionColorFollowsSystem();
            PreferredThemeStyle prefStyle = useSystemAccent || useSystemSelection ? LafManager.getPreferredThemeStyle() : null;
            Theme theme = this.getTheme(prefStyle);
            Color accentColor = null;
            Color selectionColor = null;
            if (theme.supportsCustomAccentColor()) {
                Color color = accentColor = useSystemAccent ? prefStyle.getAccentColorRule().getAccentColor() : this.getSelectedColor(ThemeSettingsUI.this.accentChooser);
            }
            if (theme.supportsCustomSelectionColor()) {
                selectionColor = useSystemSelection ? prefStyle.getAccentColorRule().getSelectionColor() : this.getSelectedColor(ThemeSettingsUI.this.selectionChooser);
            }
            return AccentColorRule.fromColor(accentColor, selectionColor);
        }

        @Override
        public FontSizeRule getFontSizeRule() {
            return this.isFontSizeFollowsSystem() ? LafManager.getPreferredThemeStyle().getFontSizeRule() : FontSizeRule.relativeAdjustment((int)ThemeSettingsUI.this.fontSlider.getValue());
        }

        @Override
        public Theme getTheme() {
            return this.getTheme(null);
        }

        private Theme getTheme(PreferredThemeStyle preferredThemeStyle) {
            if (this.isThemeFollowsSystem()) {
                PreferredThemeStyle prefStyle = preferredThemeStyle != null ? preferredThemeStyle : LafManager.getPreferredThemeStyle();
                return LafManager.themeForPreferredStyle(prefStyle);
            }
            return this.getSelectedTheme();
        }

        private Theme getSelectedTheme() {
            Theme selected = (Theme)ThemeSettingsUI.this.themeComboBox.getSelectedItem();
            if (selected == null) {
                selected = LafManager.getInstalledTheme();
                selected = selected != null ? selected : LafManager.getTheme();
                this.setTheme(selected);
            }
            return selected;
        }

        @Override
        public void setSystemPreferencesEnabled(boolean enabled) {
            TristateState state = TristateState.DESELECTED;
            if (!(!enabled || !this.isFontSizeFollowsSystem() && ThemeSettingsUI.this.fontSizeFollowsSystem.isEnabled() || !this.isThemeFollowsSystem() && ThemeSettingsUI.this.themeFollowsSystem.isEnabled() || !this.isAccentColorFollowsSystem() && ThemeSettingsUI.this.accentColorFollowsSystem.isEnabled() || !this.isSelectionColorFollowsSystem() && ThemeSettingsUI.this.selectionColorFollowsSystem.isEnabled())) {
                state = TristateState.SELECTED;
            } else if (enabled) {
                ThemeSettingsUI.this.enabledSystemPreferences.getTristateModel().setIndeterminate();
                return;
            }
            ThemeSettingsUI.this.enabledSystemPreferences.getTristateModel().setState(state);
        }

        @Override
        public void setAccentColorFollowsSystem(boolean accentColorFollowsSystem) {
            ThemeSettingsUI.this.accentColorFollowsSystem.setSelected(accentColorFollowsSystem && this.isSystemAccentColorSupported(false));
        }

        @Override
        public void setFontSizeFollowsSystem(boolean fontSizeFollowsSystem) {
            ThemeSettingsUI.this.fontSizeFollowsSystem.setSelected(fontSizeFollowsSystem && this.isSystemFontSizeSupported(false));
        }

        @Override
        public void setSelectionColorFollowsSystem(boolean selectionColorFollowsSystem) {
            ThemeSettingsUI.this.selectionColorFollowsSystem.setSelected(selectionColorFollowsSystem && this.isSystemSelectionColorSupported(false));
        }

        @Override
        public void setThemeFollowsSystem(boolean themeFollowsSystem) {
            ThemeSettingsUI.this.themeFollowsSystem.setSelected(themeFollowsSystem && this.isSystemThemeSupported(false));
        }

        @Override
        public void setAccentColorRule(AccentColorRule accentColorRule) {
            if (accentColorRule == null) {
                this.setAccentColorRule(null, null);
            } else {
                this.setAccentColorRule(accentColorRule.getAccentColor(), accentColorRule.getSelectionColor());
            }
        }

        protected void setAccentColorRule(Color accentColor, Color selectionColor) {
            ThemeSettingsUI.this.setAccentColor(accentColor);
            ThemeSettingsUI.this.setSelectionColor(selectionColor);
        }

        @Override
        public void setFontSizeRule(FontSizeRule fontSizeRule) {
            if (fontSizeRule == null) {
                ThemeSettingsUI.this.fontSlider.setValue(FontSizePreset.NORMAL.getPercentage());
            } else {
                ThemeSettingsUI.this.fontSlider.setValue(fontSizeRule.getPercentage());
            }
        }

        @Override
        public void setTheme(Theme theme) {
            ThemeSettingsUI.this.themeComboBox.setSelectedItem(LafManager.getClosestMatchForTheme(theme));
        }
    }
}

