/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.auto.service.AutoService;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Function.class})
public class TimeFunction
extends AbstractFunction
implements TestStateListener {
    private static final String KEY = "__time";
    private static final Pattern DIVISOR_PATTERN = Pattern.compile("/\\d+");
    private static final List<String> desc = new ArrayList<String>();
    private static final Map<String, String> aliases = new HashMap<String, String>();
    private static final Logger log = LoggerFactory.getLogger(TimeFunction.class);
    private static final LoadingCache<String, Supplier<String>> DATE_TIME_FORMATTER_CACHE = Caffeine.newBuilder().maximumSize(1000L).build(fmt -> {
        DateTimeFormatter df;
        if (DIVISOR_PATTERN.matcher((CharSequence)fmt).matches()) {
            long div = Long.parseLong(fmt.substring(1));
            return () -> Long.toString(System.currentTimeMillis() / div);
        }
        try {
            df = DateTimeFormatter.ofPattern(fmt).withZone(ZoneId.systemDefault());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to parse date format " + fmt, e);
        }
        if (TimeFunction.isPossibleUsageOfUInFormat(df, fmt)) {
            log.warn(MessageFormat.format(JMeterUtils.getResString((String)"time_format_changed"), fmt));
        }
        return () -> df.format(Instant.now());
    });
    private String format = "";
    private String variable = "";

    private static boolean isPossibleUsageOfUInFormat(DateTimeFormatter df, String fmt) {
        ZoneId mst = ZoneId.of("-07:00");
        return fmt.contains("u") && df.withZone(mst).format(ZonedDateTime.of(2006, 1, 2, 15, 4, 5, 6, mst)).contains("2006");
    }

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars;
        String datetime;
        if (this.format.isEmpty()) {
            datetime = Long.toString(System.currentTimeMillis());
        } else {
            String fmt = aliases.get(this.format);
            if (fmt == null) {
                fmt = this.format;
            }
            datetime = (String)((Supplier)DATE_TIME_FORMATTER_CACHE.get((Object)fmt)).get();
        }
        if (!this.variable.isEmpty() && (vars = this.getVariables()) != null) {
            vars.put(this.variable, datetime);
        }
        return datetime;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 0, 2);
        Object[] values = parameters.toArray();
        int count = values.length;
        if (count > 0) {
            this.format = ((CompoundVariable)values[0]).execute();
        }
        if (count > 1) {
            this.variable = ((CompoundVariable)values[1]).execute().trim();
        }
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    public void testStarted() {
        DATE_TIME_FORMATTER_CACHE.invalidateAll();
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public void testEnded() {
        DATE_TIME_FORMATTER_CACHE.invalidateAll();
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    static {
        desc.add(JMeterUtils.getResString((String)"time_format"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
        aliases.put("YMD", JMeterUtils.getPropDefault((String)"time.YMD", (String)"yyyyMMdd"));
        aliases.put("HMS", JMeterUtils.getPropDefault((String)"time.HMS", (String)"HHmmss"));
        aliases.put("YMDHMS", JMeterUtils.getPropDefault((String)"time.YMDHMS", (String)"yyyyMMdd-HHmmss"));
        aliases.put("USER1", JMeterUtils.getPropDefault((String)"time.USER1", (String)""));
        aliases.put("USER2", JMeterUtils.getPropDefault((String)"time.USER2", (String)""));
    }
}

