/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.coord;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.coord.CoordinatesMapperKt;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProviderBase;
import org.jetbrains.letsPlot.core.plot.builder.coord.FixedRatioCoordProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J$\u0010\u000f\u001a\u00020\u00102\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/coord/ProjectionCoordProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProviderBase;", "projection", "Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "xLim", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "yLim", "flipped", "", "(Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Z)V", "adjustGeomSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "hDomain", "vDomain", "geomSize", "with", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nProjectionCoordProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectionCoordProvider.kt\norg/jetbrains/letsPlot/core/plot/builder/coord/ProjectionCoordProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class ProjectionCoordProvider
extends CoordProviderBase {
    public ProjectionCoordProvider(@NotNull Projection projection, @Nullable DoubleSpan xLim, @Nullable DoubleSpan yLim, boolean flipped) {
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        super(xLim, yLim, flipped, projection);
    }

    @Override
    @NotNull
    public CoordProvider with(@Nullable DoubleSpan xLim, @Nullable DoubleSpan yLim, boolean flipped) {
        return new ProjectionCoordProvider(this.getProjection(), xLim, yLim, flipped);
    }

    @Override
    @NotNull
    public DoubleVector adjustGeomSize(@NotNull DoubleSpan hDomain, @NotNull DoubleSpan vDomain, @NotNull DoubleVector geomSize) {
        Intrinsics.checkNotNullParameter((Object)hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter((Object)vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
        DoubleRectangle it = new DoubleRectangle(hDomain, vDomain);
        boolean bl = false;
        it = this.getFlipped() ? it.flip() : it;
        boolean bl2 = false;
        it = CoordinatesMapperKt.projectDomain((Projection)this.getProjection(), (DoubleRectangle)it);
        boolean bl3 = false;
        DoubleRectangle bbox = this.getFlipped() ? it.flip() : it;
        double domainRatio = bbox.getWidth() / bbox.getHeight();
        return FixedRatioCoordProvider.Companion.reshapeGeom(geomSize, domainRatio);
    }
}

