/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.crud;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;

public class InsertStatement
extends Statement {
    private PartialPath device;
    private long[] times;
    private String[] measurementList;
    private List<Object[]> valuesList;
    private boolean isAligned;

    public InsertStatement() {
        this.statementType = StatementType.INSERT;
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String m : this.measurementList) {
            PartialPath fullPath = this.device.concatNode(m);
            ret.add(fullPath);
        }
        return ret;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        List<PartialPath> checkedPaths = this.getPaths();
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathListPermission(userName, checkedPaths, PrivilegeType.WRITE_DATA.ordinal()), checkedPaths, PrivilegeType.WRITE_DATA);
    }

    public PartialPath getDevice() {
        return this.device;
    }

    public void setDevice(PartialPath device) {
        this.device = device;
    }

    public String[] getMeasurementList() {
        return this.measurementList;
    }

    public void setMeasurementList(String[] measurementList) {
        this.measurementList = measurementList;
    }

    public List<Object[]> getValuesList() {
        return this.valuesList;
    }

    public void setValuesList(List<Object[]> valuesList) {
        this.valuesList = valuesList;
    }

    public long[] getTimes() {
        return this.times;
    }

    public void setTimes(long[] times) {
        this.times = times;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public void setAligned(boolean aligned) {
        this.isAligned = aligned;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInsert(this, context);
    }
}

