/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.rpc.UrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeUrlUtils {
    private static final Logger logger = LoggerFactory.getLogger(NodeUrlUtils.class);
    public static final String WILD_CARD_ADDRESS = "0.0.0.0";
    public static final String LOOPBACK_HOST_NAME = "localhost";

    public static String convertTEndPointUrl(TEndPoint endPoint) {
        StringJoiner url = new StringJoiner(":");
        url.add(endPoint.getIp());
        url.add(String.valueOf(endPoint.getPort()));
        return url.toString();
    }

    public static String convertTEndPointUrls(List<TEndPoint> endPoints) {
        StringJoiner urls = new StringJoiner(",");
        for (TEndPoint endPoint : endPoints) {
            urls.add(NodeUrlUtils.convertTEndPointUrl(endPoint));
        }
        return urls.toString();
    }

    public static TEndPoint parseTEndPointUrl(String endPointUrl) throws BadNodeUrlException {
        return UrlUtils.parseTEndPointIpv4AndIpv6Url((String)endPointUrl);
    }

    public static List<TEndPoint> parseTEndPointUrls(List<String> endPointUrls) {
        if (endPointUrls == null) {
            throw new NumberFormatException("endPointUrls is null");
        }
        ArrayList<TEndPoint> result = new ArrayList<TEndPoint>();
        for (String url : endPointUrls) {
            result.add(UrlUtils.parseTEndPointIpv4AndIpv6Url((String)url));
        }
        return result;
    }

    public static List<TEndPoint> parseTEndPointUrls(String endPointUrls) throws BadNodeUrlException {
        return NodeUrlUtils.parseTEndPointUrls(Arrays.asList(endPointUrls.split(",")));
    }

    public static String convertTConfigNodeUrl(TConfigNodeLocation configNodeLocation) {
        StringJoiner url = new StringJoiner(",");
        url.add(String.valueOf(configNodeLocation.getConfigNodeId()));
        url.add(NodeUrlUtils.convertTEndPointUrl(configNodeLocation.getInternalEndPoint()));
        url.add(NodeUrlUtils.convertTEndPointUrl(configNodeLocation.getConsensusEndPoint()));
        return url.toString();
    }

    public static String convertTConfigNodeUrls(List<TConfigNodeLocation> configNodeLocations) {
        StringJoiner urls = new StringJoiner(";");
        for (TConfigNodeLocation configNodeLocation : configNodeLocations) {
            urls.add(NodeUrlUtils.convertTConfigNodeUrl(configNodeLocation));
        }
        return urls.toString();
    }

    public static TConfigNodeLocation parseTConfigNodeUrl(String configNodeUrl) throws BadNodeUrlException {
        String[] split = configNodeUrl.split(",");
        if (split.length != 3) {
            logger.warn("Bad ConfigNode url: {}", (Object)configNodeUrl);
            throw new BadNodeUrlException(String.format("Bad node url: %s", configNodeUrl));
        }
        return new TConfigNodeLocation(Integer.parseInt(split[0]), UrlUtils.parseTEndPointIpv4AndIpv6Url((String)split[1]), UrlUtils.parseTEndPointIpv4AndIpv6Url((String)split[2]));
    }

    public static List<TConfigNodeLocation> parseTConfigNodeUrls(List<String> configNodeUrls) throws BadNodeUrlException {
        ArrayList<TConfigNodeLocation> result = new ArrayList<TConfigNodeLocation>();
        for (String url : configNodeUrls) {
            result.add(NodeUrlUtils.parseTConfigNodeUrl(url));
        }
        return result;
    }

    public static List<TConfigNodeLocation> parseTConfigNodeUrls(String configNodeUrls) throws BadNodeUrlException {
        return NodeUrlUtils.parseTConfigNodeUrls(Arrays.asList(configNodeUrls.split(";")));
    }

    public static boolean containsLocalAddress(List<String> addressesOrHostNames) throws UnknownHostException {
        if (addressesOrHostNames == null) {
            return false;
        }
        Set<String> selfAddresses = NodeUrlUtils.getAllLocalAddresses();
        for (String addressOrHostName : addressesOrHostNames) {
            if (addressOrHostName == null) continue;
            Set translatedAddresses = Arrays.stream(InetAddress.getAllByName(addressOrHostName)).map(InetAddress::getHostAddress).collect(Collectors.toCollection(HashSet::new));
            translatedAddresses.retainAll(selfAddresses);
            if (translatedAddresses.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getAllLocalAddresses() throws UnknownHostException {
        Set selfAddresses = Arrays.stream(InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())).map(InetAddress::getHostAddress).collect(Collectors.toCollection(HashSet::new));
        selfAddresses.addAll(Arrays.stream(InetAddress.getAllByName(LOOPBACK_HOST_NAME)).map(InetAddress::getHostAddress).collect(Collectors.toCollection(HashSet::new)));
        selfAddresses.add(WILD_CARD_ADDRESS);
        return selfAddresses;
    }
}

