/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IncludeKeyMaterial {
    ALL_KEY_MATERIAL("ALL_KEY_MATERIAL"),
    ROTATIONS_ONLY("ROTATIONS_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IncludeKeyMaterial> VALUE_MAP;
    private final String value;

    private IncludeKeyMaterial(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IncludeKeyMaterial fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IncludeKeyMaterial> knownValues() {
        EnumSet<IncludeKeyMaterial> knownValues = EnumSet.allOf(IncludeKeyMaterial.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IncludeKeyMaterial.class, IncludeKeyMaterial::toString);
    }
}

